package au.gov.nehta.xsp.impl;

import java.security.cert.X509Certificate;

import org.w3c.dom.Element;

public final class TextUtils {

  private TextUtils() {}

  /*
   * Return descriptive text identifying a certificate.
   */
  public static String getDesc(X509Certificate certificate) {
    StringBuilder strBuilder = new StringBuilder();
    strBuilder.append("[");
    strBuilder.append(CertificateUtils.getSubjectName(certificate));
    strBuilder.append("]");
    return strBuilder.toString();
  }

  /*
   * Return descriptive text identifying an element.
   */
  public static String getDesc(Element element) {
    StringBuilder strBuilder = new StringBuilder();
    strBuilder.append("[");
    if (element == null) {
      strBuilder.append("null");
    } else {
      strBuilder.append(element.getTagName());
    }
    strBuilder.append("]");
    return strBuilder.toString();
  }

}
