
DELIMITER //

DROP PROCEDURE IF EXISTS createTransitiveClosure //
CREATE PROCEDURE createTransitiveClosure ()

BEGIN
-- Create the Transitive Closure table schema
    DROP TABLE IF EXISTS rf2_Transitive_Closure;
    CREATE TABLE rf2_Transitive_Closure (
            sourceid BIGINT NOT NULL,
            destinationid BIGINT NOT NULL,
            PRIMARY KEY (sourceid, destinationid)
            ) ENGINE = MyISAM;

-- Insert the immediate set of IS A relationships from the distributed relationships table
    INSERT INTO rf2_Transitive_Closure (sourceid,destinationid)
        SELECT DISTINCT sourceid,destinationid
        FROM rf2_relationships_snapshot
        WHERE typeid = 116680003 -- "IS A" relationship type
        AND active = 1;

-- Recursively loop through the transitive closure adding additional relationships until there are no more left to insert
    REPEAT

    INSERT INTO rf2_Transitive_Closure (sourceid,destinationid)
        SELECT DISTINCT b.sourceid,a.destinationid
        FROM rf2_Transitive_Closure a
        JOIN rf2_Transitive_Closure b 
            ON a.sourceid = b.destinationid
        LEFT JOIN rf2_Transitive_Closure c 
            ON c.sourceid = b.sourceid
        AND c.destinationid = a.destinationid
        WHERE c.sourceid IS NULL;

    SET @x = row_count();
-- Non essential output logger.
    SELECT CONCAT ('Inserted ',@x);

    UNTIL @x = 0
END REPEAT;

CREATE INDEX idx_TransitiveClosure_sourceid ON rf2_Transitive_Closure (sourceid);
CREATE INDEX idx_TransitiveClosure_destinationid ON rf2_Transitive_Closure (destinationid);

END //

