/* --------------------------------------------------------------------------
-- Demonstration SNOMED CT-AU Schema creation script
-- The script creates the schema and associated tables 
-- to provide platform for installing and querying SNOMED CT-AU -- content:
------------------------------------------------------------------------*/

DROP DATABASE IF EXISTS `sctau`;
CREATE DATABASE `sctau`;
USE `sctau`;

--
-- Table structure for table `rf2_concepts_full`
--

DROP TABLE IF EXISTS `rf2_concepts_full`;
CREATE TABLE IF NOT EXISTS `rf2_concepts_full` (
  `id` bigint(18) NOT NULL,
  `effectivetime` timestamp NOT NULL default CURRENT_TIMESTAMP on update CURRENT_TIMESTAMP,
  `active` int(1) NOT NULL,
  `moduleid` bigint(18) NOT NULL,
  `definitionstatusid` bigint(18) NOT NULL,
  PRIMARY KEY  (`id`,`effectivetime`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;


--
-- Table structure for table `rf2_descriptions_full`
--

DROP TABLE IF EXISTS `rf2_descriptions_full`;
CREATE TABLE IF NOT EXISTS `rf2_descriptions_full` (
  `id` bigint(18) NOT NULL,
  `effectivetime` timestamp NOT NULL default CURRENT_TIMESTAMP on update CURRENT_TIMESTAMP,
  `active` int(1) NOT NULL,
  `moduleid` bigint(18) NOT NULL,
  `conceptid` bigint(18) NOT NULL,
  `languagecode` varchar(10) collate utf8_unicode_ci NOT NULL,
  `typeid` bigint(18) NOT NULL,
  `term` varchar(500) collate utf8_unicode_ci NOT NULL,
  `casesignificanceid` bigint(18) NOT NULL,
  PRIMARY KEY  (`id`,`effectivetime`),
  CONSTRAINT FOREIGN KEY (conceptid) 
	REFERENCES rf2_concepts_full(id) ON DELETE CASCADE,
  CONSTRAINT FOREIGN KEY (moduleid) 
	REFERENCES rf2_concepts_full(id) ON DELETE CASCADE,
  CONSTRAINT FOREIGN KEY (typeid) 
	REFERENCES rf2_concepts_full(id) ON DELETE CASCADE
) ENGINE=MyISAM DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;



--
-- Table structure for table `rf2_relationships_full`
--

DROP TABLE IF EXISTS `rf2_relationships_full`;
CREATE TABLE IF NOT EXISTS `rf2_relationships_full` (
  `id` bigint(18) NOT NULL,
  `effectivetime` timestamp NOT NULL default CURRENT_TIMESTAMP on update CURRENT_TIMESTAMP,
  `active` int(1) NOT NULL,
  `moduleid` bigint(18) NOT NULL,
  `sourceid` bigint(18) NOT NULL,
  `destinationid` bigint(18) NOT NULL,
  `relationshipgroup` bigint(18) NOT NULL,
  `typeid` bigint(18) NOT NULL,
  `characteristictypeid` bigint(18) NOT NULL,
  `modifierid` bigint(18) NOT NULL,
  PRIMARY KEY  (`id`,`effectivetime`),
  CONSTRAINT FOREIGN KEY (moduleid) 
	REFERENCES rf2_concepts_full(id) ON DELETE CASCADE,
  CONSTRAINT FOREIGN KEY (typeid) 
	REFERENCES rf2_concepts_full(id) ON DELETE CASCADE,
  CONSTRAINT FOREIGN KEY (characteristictypeid) 
	REFERENCES rf2_concepts_full(id) ON DELETE CASCADE,
  CONSTRAINT FOREIGN KEY (sourceid) 
	REFERENCES rf2_concepts_full(id) ON DELETE CASCADE,
  CONSTRAINT FOREIGN KEY (destinationid) 
	REFERENCES rf2_concepts_full(id) ON DELETE CASCADE
) ENGINE=MyISAM DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;


--
-- Table structure for table `rf2_language_refset_full`
--

DROP TABLE IF EXISTS `rf2_language_refset_full`;
CREATE TABLE IF NOT EXISTS `rf2_language_refset_full` (
  `id` varchar(36) NOT NULL,
  `effectivetime` timestamp NOT NULL default CURRENT_TIMESTAMP on update CURRENT_TIMESTAMP,
  `active` int(1) NOT NULL,
  `moduleid` bigint(18) NOT NULL,
  `refsetid` bigint(18) NOT NULL,
  `referencedcomponentid` bigint(18) NOT NULL,
  `acceptabilityid` bigint(18) NOT NULL,
  PRIMARY KEY  (`id`,`effectivetime`),
  CONSTRAINT FOREIGN KEY (moduleid) 
	REFERENCES rf2_concepts_full(id) ON DELETE CASCADE,
  CONSTRAINT FOREIGN KEY (refsetid) 
	REFERENCES rf2_concepts_full(id) ON DELETE CASCADE,
  CONSTRAINT FOREIGN KEY (referencedcomponentid) 
	REFERENCES rf2_descriptions_full(id) ON DELETE CASCADE
) ENGINE=MyISAM DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;


--
-- Table structure for table `rf2_refset_full`
--

DROP TABLE IF EXISTS `rf2_refset_full`;
CREATE TABLE IF NOT EXISTS `rf2_refset_full` (
  `id` varchar(36) NOT NULL,
  `effectivetime` timestamp NOT NULL default CURRENT_TIMESTAMP on update CURRENT_TIMESTAMP,
  `active` int(1) NOT NULL,
  `moduleid` bigint(18) NOT NULL,
  `refsetid` bigint(18) NOT NULL,
  `referencedcomponentid` bigint(18) NOT NULL,
  PRIMARY KEY  (`id`,`effectivetime`),
  CONSTRAINT FOREIGN KEY (moduleid) 
	REFERENCES rf2_concepts_full(id) ON DELETE CASCADE,
  CONSTRAINT FOREIGN KEY (refsetid) 
	REFERENCES rf2_concepts_full(id) ON DELETE CASCADE,
  CONSTRAINT FOREIGN KEY (referencedcomponentid) 
	REFERENCES rf2_concepts_full(id) ON DELETE CASCADE
) ENGINE=MyISAM DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;






