
-- ------------------------------------------------------------------------------
-- IMPORT FILES
-- ------------------------------------------------------------------------------

-- Set the database schema to owner of SCTAU tables
USE `sctau`;

-- RF2_CONCEPTS_SNAPSHOT
TRUNCATE TABLE rf2_concepts_snapshot
;
LOAD DATA LOCAL INFILE 'release-files/RF2Release/Snapshot/Terminology/sct2_Concept_Snapshot_AU1000036_20150531.txt' INTO TABLE rf2_concepts_snapshot CHARACTER SET 'utf8' LINES TERMINATED BY '\r\n' IGNORE 1 LINES
(id, @effectivetime, active, moduleid, definitionstatusid) 
set effectivetime = str_to_date(@effectivetime, '%Y%m%d')
;

-- RF2_DESCRIPTIONS_SNAPSHOT
TRUNCATE TABLE rf2_descriptions_snapshot
;
LOAD DATA LOCAL INFILE 'release-files/RF2Release/Snapshot/Terminology/sct2_Description_Snapshot-en-AU_AU1000036_20150531.txt' INTO TABLE rf2_descriptions_snapshot CHARACTER SET 'utf8' LINES TERMINATED BY '\r\n' IGNORE 1 LINES
(id, @effectivetime, active, moduleid, conceptid, languagecode, typeid, term, casesignificanceid) 
set effectivetime = str_to_date(@effectivetime, '%Y%m%d')
;

-- RF2_RELATIONSHIPS_SNAPSHOT
TRUNCATE TABLE rf2_relationships_snapshot
;
LOAD DATA LOCAL INFILE 'release-files/RF2Release/Snapshot/Terminology/sct2_Relationship_Snapshot_AU1000036_20150531.txt' INTO TABLE rf2_relationships_snapshot CHARACTER SET 'utf8' LINES TERMINATED BY '\r\n' IGNORE 1 LINES
(id, @effectivetime, active, moduleid, sourceid, destinationid, relationshipgroup, typeid, characteristictypeid, modifierid) 
set effectivetime = str_to_date(@effectivetime, '%Y%m%d')
;

-- RF2_LANGUAGE_REFSET_SNAPSHOT
TRUNCATE TABLE rf2_language_refset_snapshot
;
LOAD DATA LOCAL INFILE 'release-files/RF2Release/Snapshot/Refset/Language/der2_cRefset_LanguageSnapshot-en-AU_AU1000036_20150531.txt' INTO TABLE rf2_language_refset_snapshot CHARACTER SET 'utf8' LINES TERMINATED BY '\r\n' IGNORE 1 LINES
(id, @effectivetime, active, moduleid, refsetid, referencedcomponentid, acceptabilityid) 
set effectivetime = str_to_date(@effectivetime, '%Y%m%d')
;

-- RF2_REFSET_SNAPSHOT
TRUNCATE TABLE rf2_refset_snapshot
;
LOAD DATA LOCAL INFILE 'release-files/RF2Release/Snapshot/Refset/Content/der2_Refset_<REFSETNAME>Snapshot_AU1000036_20150531.txt' INTO TABLE rf2_refset_snapshot CHARACTER SET 'utf8' LINES TERMINATED BY '\r\n' IGNORE 1 LINES
(id, @effectivetime, active, moduleid, refsetid, referencedcomponentid) 
set effectivetime = str_to_date(@effectivetime, '%Y%m%d')
;
