/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.web.portunif;

import com.sun.enterprise.web.connector.grizzly.SelectorThread;
import com.sun.enterprise.web.connector.grizzly.ssl.SSLSelectorThread;
import com.sun.enterprise.web.connector.grizzly.ssl.SSLUtils;
import com.sun.enterprise.web.portunif.ProtocolFinder;
import com.sun.enterprise.web.portunif.util.ProtocolInfo;
import java.io.EOFException;
import java.io.IOException;
import java.nio.Buffer;
import java.nio.ByteBuffer;
import java.nio.channels.SelectionKey;
import java.nio.channels.SocketChannel;
import java.util.Enumeration;
import javax.net.ssl.SSLEngine;
import javax.net.ssl.SSLEngineResult;

public class TlsProtocolFinder
implements ProtocolFinder {
    private static final int appBBSize = 20480;
    private boolean needClientAuth = false;
    private boolean wantClientAuth = false;

    public TlsProtocolFinder() {
        Enumeration<SelectorThread> selectors = SelectorThread.getSelectors();
        while (selectors.hasMoreElements()) {
            SelectorThread sel = selectors.nextElement();
            if (!(sel instanceof SSLSelectorThread)) continue;
            this.needClientAuth = ((SSLSelectorThread)sel).isNeedClientAuth();
            this.wantClientAuth = ((SSLSelectorThread)sel).isWantClientAuth();
            break;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void find(ProtocolInfo protocolInfo) throws IOException {
        block17: {
            if (protocolInfo.sslContext == null) {
                return;
            }
            SelectionKey key = protocolInfo.key;
            SocketChannel socketChannel = (SocketChannel)key.channel();
            SSLEngine sslEngine = protocolInfo.sslEngine;
            if (protocolInfo.sslContext != null && sslEngine == null) {
                sslEngine = protocolInfo.sslContext.createSSLEngine();
                sslEngine.setUseClientMode(false);
                sslEngine.setNeedClientAuth(this.needClientAuth);
                sslEngine.setWantClientAuth(this.wantClientAuth);
            }
            Buffer inputBB = null;
            ByteBuffer outputBB = null;
            ByteBuffer byteBuffer = null;
            int inputBBSize = sslEngine.getSession().getPacketBufferSize();
            if (protocolInfo.inputBB == null || inputBB != null && inputBBSize > inputBB.capacity()) {
                inputBB = ByteBuffer.allocate(inputBBSize * 2);
                outputBB = ByteBuffer.allocate(inputBBSize * 2);
                byteBuffer = ByteBuffer.allocate(inputBBSize * 2);
                inputBBSize = sslEngine.getSession().getApplicationBufferSize();
                if (inputBBSize > byteBuffer.capacity()) {
                    ByteBuffer newBB = ByteBuffer.allocate(inputBBSize);
                    byteBuffer.flip();
                    newBB.put(byteBuffer);
                    byteBuffer = newBB;
                }
            } else {
                inputBB = protocolInfo.inputBB;
                outputBB = protocolInfo.outputBB;
                byteBuffer = protocolInfo.byteBuffer;
            }
            outputBB.position(0);
            outputBB.limit(0);
            if (protocolInfo.bytesRead > 0) {
                ((ByteBuffer)inputBB).put((ByteBuffer)protocolInfo.byteBuffer.flip());
            }
            SSLEngineResult.HandshakeStatus handshakeStatus = SSLEngineResult.HandshakeStatus.NEED_UNWRAP;
            boolean OK = true;
            if (protocolInfo.handshake) {
                try {
                    byteBuffer = SSLUtils.doHandshake(key, byteBuffer, (ByteBuffer)inputBB, outputBB, sslEngine, handshakeStatus, SSLUtils.getReadTimeout());
                    protocolInfo.handshake = false;
                }
                catch (EOFException ex) {
                }
                catch (Throwable ex) {
                    OK = false;
                    byteBuffer.put((ByteBuffer)inputBB);
                }
            }
            try {
                int byteRead;
                if (!OK) break block17;
                int readTimeout = SSLUtils.getReadTimeout();
                if (inputBB.position() > 0) {
                    readTimeout = 0;
                }
                if ((byteRead = SSLUtils.doRead(key, (ByteBuffer)inputBB, sslEngine, readTimeout)) > -1) {
                    protocolInfo.byteBuffer = SSLUtils.unwrapAll(byteBuffer, (ByteBuffer)inputBB, sslEngine);
                    protocolInfo.bytesRead = byteBuffer.position();
                    if (protocolInfo.bytesRead == 0) {
                        OK = false;
                    }
                    break block17;
                }
                throw new EOFException();
            }
            finally {
                String protocol = protocolInfo.protocol;
                protocolInfo.inputBB = inputBB;
                protocolInfo.byteBuffer = byteBuffer;
                protocolInfo.outputBB = outputBB;
                protocolInfo.sslEngine = sslEngine;
                protocolInfo.isSecure = true;
                if (!OK) {
                    protocolInfo.bytesRead = byteBuffer.position();
                    protocolInfo.protocol = null;
                    protocolInfo.isSecure = false;
                }
                protocolInfo.socketChannel = (SocketChannel)key.channel();
            }
        }
    }
}

