/*
 * Decompiled with CFR 0.152.
 */
package com.sun.xml.ws.rx.rm.policy.spi_impl;

import com.sun.istack.logging.Logger;
import com.sun.xml.ws.api.WSBinding;
import com.sun.xml.ws.api.model.SEIModel;
import com.sun.xml.ws.policy.PolicyException;
import com.sun.xml.ws.policy.PolicyMap;
import com.sun.xml.ws.policy.PolicySubject;
import com.sun.xml.ws.policy.jaxws.spi.PolicyMapConfigurator;
import com.sun.xml.ws.rx.rm.api.ReliableMessagingFeature;
import java.util.Collection;
import java.util.LinkedList;
import java.util.logging.Level;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RmPolicyMapConfigurator
implements PolicyMapConfigurator {
    private static final Logger LOGGER = Logger.getLogger(RmPolicyMapConfigurator.class);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Collection<PolicySubject> update(PolicyMap policyMap, SEIModel model, WSBinding wsBinding) throws PolicyException {
        LinkedList<PolicySubject> subjects = new LinkedList<PolicySubject>();
        try {
            LOGGER.entering(policyMap, model, wsBinding);
            this.updateReliableMessagingSettings(subjects, wsBinding, model, policyMap);
            LinkedList<PolicySubject> linkedList = subjects;
            return linkedList;
        }
        finally {
            LOGGER.exiting(subjects);
        }
    }

    private void updateReliableMessagingSettings(Collection<PolicySubject> subjects, WSBinding wsBinding, SEIModel model, PolicyMap policyMap) throws PolicyException, IllegalArgumentException {
        ReliableMessagingFeature feature = wsBinding.getFeature(ReliableMessagingFeature.class);
        if (feature == null || !feature.isEnabled()) {
            return;
        }
        if (LOGGER.isLoggable(Level.FINEST)) {
            LOGGER.finest(String.format("Reliable messaging feature enabled on service '%s', port '%s'", model.getServiceQName(), model.getPortName()));
        }
    }
}

