/*
 * Decompiled with CFR 0.152.
 */
package com.sun.xml.ws.security.opt.impl.message;

import com.sun.xml.stream.buffer.MutableXMLStreamBuffer;
import com.sun.xml.stream.buffer.stax.StreamWriterBufferCreator;
import com.sun.xml.ws.api.SOAPVersion;
import com.sun.xml.ws.api.message.Message;
import com.sun.xml.ws.message.jaxb.JAXBMessage;
import com.sun.xml.ws.message.source.PayloadSourceMessage;
import com.sun.xml.ws.message.stream.StreamMessage;
import com.sun.xml.ws.security.opt.api.SecurityElement;
import com.sun.xml.ws.security.opt.api.SecurityElementWriter;
import com.sun.xml.ws.security.opt.impl.util.NamespaceContextEx;
import com.sun.xml.ws.security.opt.impl.util.XMLStreamFilterWithId;
import com.sun.xml.wss.impl.c14n.StAXEXC14nCanonicalizerImpl;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import javax.xml.stream.XMLStreamWriter;

public class SOAPBody {
    private static final String BODY = "Body";
    private static final String BODY_PREFIX = "S";
    private Message message;
    private SOAPVersion soapVersion;
    private SecurityElement bodyContent;
    private String wsuId;
    private String contentId;
    private MutableXMLStreamBuffer buffer = null;
    private List attributeValuePrefixes = null;

    public SOAPBody(Message message) {
        this.message = message;
        this.soapVersion = SOAPVersion.SOAP_11;
    }

    public SOAPBody(Message message, SOAPVersion soapVersion) {
        this.message = message;
        this.soapVersion = soapVersion;
    }

    public SOAPBody(byte[] payLoad, SOAPVersion soapVersion) {
        this.soapVersion = soapVersion;
    }

    public SOAPBody(SecurityElement se, SOAPVersion soapVersion) {
        this.bodyContent = se;
        this.soapVersion = soapVersion;
    }

    public SOAPVersion getSOAPVersion() {
        return this.soapVersion;
    }

    public String getId() {
        return this.wsuId;
    }

    public void setId(String id) {
        this.wsuId = id;
    }

    public String getBodyContentId() {
        if (this.contentId != null) {
            return this.contentId;
        }
        if (this.bodyContent != null) {
            return this.bodyContent.getId();
        }
        return null;
    }

    public void setBodyContentId(String id) {
        this.contentId = id;
    }

    public void writePayload(XMLStreamWriter writer) throws XMLStreamException {
        if (this.message != null) {
            if (this.getBodyContentId() == null) {
                this.message.writePayloadTo(writer);
            } else {
                boolean isSOAP12 = this.soapVersion == SOAPVersion.SOAP_12;
                XMLStreamFilterWithId xmlStreamFilterWithId = new XMLStreamFilterWithId(writer, new NamespaceContextEx(isSOAP12), this.getBodyContentId());
                this.message.writePayloadTo(xmlStreamFilterWithId);
            }
        } else if (this.bodyContent != null) {
            ((SecurityElementWriter)((Object)this.bodyContent)).writeTo(writer);
        } else if (this.buffer != null) {
            if (writer instanceof StAXEXC14nCanonicalizerImpl && this.attributeValuePrefixes != null && !this.attributeValuePrefixes.isEmpty()) {
                ArrayList prefixList = ((StAXEXC14nCanonicalizerImpl)writer).getInclusivePrefixList();
                if (prefixList == null) {
                    prefixList = new ArrayList();
                }
                prefixList.addAll(this.attributeValuePrefixes);
                HashSet set = new HashSet(prefixList);
                prefixList = new ArrayList(set);
                ((StAXEXC14nCanonicalizerImpl)writer).setInclusivePrefixList(prefixList);
            }
            this.buffer.writeToXMLStreamWriter(writer);
        } else {
            throw new UnsupportedOperationException();
        }
    }

    public void writeTo(XMLStreamWriter writer) throws XMLStreamException {
        writer.writeStartElement(BODY_PREFIX, BODY, this.soapVersion.nsUri);
        if (this.wsuId != null) {
            writer.writeAttribute("wsu", "http://docs.oasis-open.org/wss/2004/01/oasis-200401-wss-wssecurity-utility-1.0.xsd", "Id", this.wsuId);
        }
        this.writePayload(writer);
        writer.writeEndElement();
    }

    public String getPayloadNamespaceURI() {
        if (this.message != null) {
            return this.message.getPayloadNamespaceURI();
        }
        if (this.bodyContent != null) {
            return this.bodyContent.getNamespaceURI();
        }
        return null;
    }

    public String getPayloadLocalPart() {
        if (this.message != null) {
            return this.message.getPayloadLocalPart();
        }
        if (this.bodyContent != null) {
            return this.bodyContent.getLocalPart();
        }
        return null;
    }

    public XMLStreamReader read() throws XMLStreamException {
        if (this.message != null) {
            return this.message.readPayload();
        }
        if (this.bodyContent != null) {
            return this.bodyContent.readHeader();
        }
        throw new XMLStreamException("Invalid SOAPBody");
    }

    public void cachePayLoad() throws XMLStreamException {
        if (this.message != null && (this.message instanceof StreamMessage || this.message instanceof PayloadSourceMessage || this.message instanceof JAXBMessage) && this.buffer == null) {
            this.buffer = new MutableXMLStreamBuffer();
            StreamWriterBufferCreator creator = new StreamWriterBufferCreator(this.buffer);
            creator.setCheckAttributeValue(true);
            this.writePayload(creator);
            this.attributeValuePrefixes = creator.getAttributeValuePrefixes();
            this.message = null;
        }
    }

    public List getAttributeValuePrefixes() {
        return this.attributeValuePrefixes;
    }
}

