/*
 * Decompiled with CFR 0.152.
 */
package com.sun.xml.ws.tx.at.internal;

import com.sun.istack.logging.Logger;
import com.sun.xml.ws.tx.at.WSATHelper;
import com.sun.xml.ws.tx.at.WSATXAResource;
import com.sun.xml.ws.tx.at.internal.BranchXidImpl;
import com.sun.xml.ws.tx.at.internal.JTAHelper;
import com.sun.xml.ws.tx.at.internal.XidImpl;
import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import javax.transaction.xa.XAException;
import javax.transaction.xa.XAResource;
import javax.transaction.xa.Xid;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BranchRecord
implements Externalizable {
    private static final long serialVersionUID = -8663994789749988958L;
    private static final int VERSION = 1;
    private Xid globalXid;
    private Map<Xid, RegisteredResource> registeredResources;
    private String branchAliasSuffix = "BI_WSATGatewayRM";
    private boolean logged;
    private String txLogLocation;
    private static final Logger LOGGER = Logger.getLogger(BranchRecord.class);

    public BranchRecord() {
        this.registeredResources = new HashMap<Xid, RegisteredResource>();
    }

    BranchRecord(Xid xid) {
        this.globalXid = xid;
        this.registeredResources = new HashMap<Xid, RegisteredResource>();
    }

    public synchronized RegisteredResource addSubordinate(Xid xid, WSATXAResource wsatResource) {
        this.debug("addSubordindate xid:" + xid + " wsatResource:" + wsatResource);
        RegisteredResource rr = new RegisteredResource(wsatResource);
        this.registeredResources.put(xid, rr);
        return rr;
    }

    synchronized String getBranchName(XAResource wsatResource) {
        int index = this.getResourceIndex(wsatResource);
        if (index == -1) {
            throw new IllegalStateException("WS-AT resource not associated with transaction branch " + this.globalXid);
        }
        return index + this.branchAliasSuffix;
    }

    void setLogged(boolean b) {
        this.logged = b;
    }

    boolean isLogged() {
        return this.logged;
    }

    int prepare(Xid xid) throws XAException {
        RegisteredResource rr = this.getRegisteredResource(xid);
        int vote = 0;
        try {
            vote = rr.prepare(xid);
        }
        catch (XAException xae) {
            switch (xae.errorCode) {
                case 100: {
                    throw xae;
                }
                case -4: {
                    JTAHelper.throwXAException(106, "Subordinate resource timeout.", xae);
                    break;
                }
                default: {
                    throw xae;
                }
            }
        }
        return vote;
    }

    void rollback(Xid xid) throws XAException {
        if (this.isPrimaryBranch(xid)) {
            this.debug("rollback() xid=" + xid + " ignoring primary branch ");
        }
        RegisteredResource rr = this.getRegisteredResource(xid);
        try {
            rr.rollback(xid);
        }
        catch (XAException e) {
            switch (e.errorCode) {
                case 5: 
                case 7: 
                case 8: {
                    throw e;
                }
                case -4: {
                    break;
                }
                default: {
                    throw e;
                }
            }
        }
    }

    void commit(Xid xid, boolean onePhase) throws XAException {
        if (this.isPrimaryBranch(xid)) {
            this.debug("commit() xid=" + xid + " ignoring primary branch");
        }
        RegisteredResource rr = this.getRegisteredResource(xid);
        try {
            rr.commit(xid, onePhase);
        }
        catch (XAException e) {
            switch (e.errorCode) {
                case 5: 
                case 6: 
                case 8: {
                    throw e;
                }
                case -4: {
                    break;
                }
                default: {
                    throw e;
                }
            }
        }
    }

    private synchronized int getResourceIndex(XAResource wsatResource) {
        for (int i = 0; i < this.registeredResources.size(); ++i) {
            RegisteredResource rr = this.registeredResources.get(i);
            if (!wsatResource.equals(rr.resource)) continue;
            return i;
        }
        return -1;
    }

    XAResource exists(XAResource wsatResource) {
        int resourceIndex = this.getResourceIndex(wsatResource);
        return resourceIndex == -1 ? null : this.registeredResources.get(resourceIndex).resource;
    }

    private boolean isPrimaryBranch(Xid xid) {
        return Arrays.equals(xid.getBranchQualifier(), this.globalXid.getBranchQualifier());
    }

    private int getResourceIndex(Xid xid) {
        String bqual = new String(xid.getBranchQualifier());
        int endPos = bqual.indexOf(this.branchAliasSuffix);
        if (endPos == -1) {
            return -1;
        }
        String s = bqual.substring(0, endPos);
        return Integer.parseInt(s);
    }

    private synchronized RegisteredResource getRegisteredResource(Xid xid) throws XAException {
        boolean isRegisteredBranch;
        RegisteredResource registeredResource = this.registeredResources.get(xid);
        if (registeredResource == null) {
            JTAHelper.throwXAException(-4, "Xid=" + xid);
        }
        if (registeredResource.getBranchXid() != null && !(isRegisteredBranch = Arrays.equals(registeredResource.getBranchXid().getBranchQualifier(), xid.getBranchQualifier()))) {
            WSATHelper.getInstance();
            if (WSATHelper.isDebugEnabled()) {
                byte[] branchQualifier = registeredResource.getBranchXid().getBranchQualifier();
                if (branchQualifier == null) {
                    branchQualifier = new byte[]{};
                }
                this.debug("WS-AT Branch registered branchId:\t[" + new String(branchQualifier) + "] ");
                branchQualifier = xid.getBranchQualifier();
                if (branchQualifier == null) {
                    branchQualifier = new byte[]{};
                }
                this.debug("WS-AT Branch branchId used to identify a registered resource, branchQual:" + new String(branchQualifier));
            }
            this.debug("prepare() xid=" + xid + " returning XA_RDONLY");
            JTAHelper.throwXAException(-4, "xid=" + xid);
        }
        return registeredResource;
    }

    Xid getXid() {
        return this.globalXid;
    }

    synchronized Collection<Xid> getAllXids() {
        ArrayList<Xid> xids = new ArrayList<Xid>();
        Iterator<RegisteredResource> resourceIterator = this.registeredResources.values().iterator();
        while (resourceIterator.hasNext()) {
            xids.add(resourceIterator.next().getBranchXid());
        }
        return xids;
    }

    void assignBranchXid(Xid xid) {
        int index = this.getResourceIndex(xid);
        if (index == -1) {
            return;
        }
        RegisteredResource rr = this.registeredResources.get(index);
        if (rr == null) {
            return;
        }
        if (rr.getBranchXid() == null) {
            rr.setBranchXid(xid);
        }
    }

    public void cleanup() {
    }

    synchronized boolean allResourcesCompleted() {
        int num = this.registeredResources.size();
        for (int i = 0; i < num; ++i) {
            RegisteredResource rr = this.registeredResources.get(i);
            if (rr.isCompleted()) continue;
            return false;
        }
        return true;
    }

    public void setTxLogLocation(String logLocation) {
        this.txLogLocation = logLocation;
    }

    public String getTxLogLocation() {
        return this.txLogLocation;
    }

    private void debug(String msg) {
        LOGGER.info(msg);
    }

    @Override
    public void writeExternal(ObjectOutput out) throws IOException {
        out.writeInt(1);
        out.writeInt(this.globalXid.getFormatId());
        byte[] gtrid = this.globalXid.getGlobalTransactionId();
        out.writeByte((byte)gtrid.length);
        out.write(gtrid);
        byte[] bqual = this.globalXid.getBranchQualifier();
        if (bqual == null) {
            out.writeByte(-1);
        } else {
            out.writeByte((byte)bqual.length);
            out.write(bqual);
        }
        out.writeInt(this.registeredResources.size());
        Iterator<RegisteredResource> resourceIterator = this.registeredResources.values().iterator();
        while (resourceIterator.hasNext()) {
            resourceIterator.next().writeExternal(out);
        }
    }

    @Override
    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        int version = in.readInt();
        if (version != 1) {
            throw new IOException("invalid OTSBranch version " + version);
        }
        int formatId = in.readInt();
        byte len = in.readByte();
        byte[] gtrid = new byte[len];
        in.readFully(gtrid);
        len = in.readByte();
        byte[] bqual = null;
        if (len > -1) {
            bqual = new byte[len];
            in.readFully(bqual);
        }
        this.globalXid = new XidImpl(formatId, gtrid, bqual);
        int resourceNum = in.readInt();
        for (int i = 0; i < resourceNum; ++i) {
            RegisteredResource rr = new RegisteredResource();
            rr.readExternal(in);
            rr.setPrepared();
            this.registeredResources.put(this.globalXid, rr);
        }
        this.logged = true;
    }

    public String toString() {
        return "BranchRecord:globalXid=" + this.globalXid;
    }

    class RegisteredResource
    implements Externalizable {
        private static final long serialVersionUID = 601688150453719976L;
        private static final int STATE_ACTIVE = 1;
        private static final int STATE_PREPARED = 2;
        private static final int STATE_READONLY = 3;
        private static final int STATE_COMPLETED = 4;
        private WSATXAResource resource;
        private int vote = -1;
        private int state;
        private BranchXidImpl branchXid;

        RegisteredResource() {
        }

        RegisteredResource(WSATXAResource wsatResource) {
            this.resource = wsatResource;
            this.state = 1;
        }

        private Xid getBranchXid() {
            if (this.branchXid == null) {
                return null;
            }
            return this.branchXid.getDelegate();
        }

        private void setBranchXid(Xid xid) {
            this.branchXid = new BranchXidImpl(new XidImpl(xid));
        }

        private void setPrepared() {
            this.state = 2;
        }

        XAResource getResource() {
            return this.resource;
        }

        boolean isCompleted() {
            return this.state == 4 || this.state == 3;
        }

        int prepare(Xid xid) throws XAException {
            switch (this.state) {
                case 2: 
                case 3: {
                    return this.vote;
                }
                case 4: {
                    JTAHelper.throwXAException(-5, "Resource completed.");
                }
            }
            try {
                this.vote = this.resource.prepare(xid);
                switch (this.vote) {
                    case 0: {
                        this.state = 2;
                        break;
                    }
                    case 3: {
                        this.state = 3;
                    }
                }
            }
            catch (XAException xae) {
                switch (xae.errorCode) {
                    case 100: 
                    case 101: 
                    case 102: 
                    case 103: 
                    case 104: 
                    case 105: 
                    case 106: 
                    case 107: {
                        this.state = 4;
                        throw xae;
                    }
                    case -7: 
                    case -6: 
                    case -5: 
                    case -4: 
                    case -3: {
                        throw xae;
                    }
                }
                throw xae;
            }
            return this.vote;
        }

        void commit(Xid xid, boolean onePhase) throws XAException {
            switch (this.state) {
                case 3: 
                case 4: {
                    return;
                }
            }
            try {
                this.resource.commit(xid, onePhase);
                this.state = 4;
            }
            catch (XAException xae) {
                switch (xae.errorCode) {
                    case 7: {
                        this.state = 4;
                        break;
                    }
                    case 5: 
                    case 6: 
                    case 8: {
                        this.state = 4;
                        throw xae;
                    }
                    case 100: 
                    case 101: 
                    case 102: 
                    case 103: 
                    case 104: 
                    case 105: 
                    case 106: 
                    case 107: {
                        if (onePhase) {
                            this.state = 4;
                            throw xae;
                        }
                        JTAHelper.throwXAException(8, "Invalid rollback error code thrown for 2PC commit. ", xae);
                        break;
                    }
                    case -7: 
                    case -6: 
                    case -5: 
                    case -3: {
                        throw xae;
                    }
                    case -4: {
                        this.state = 4;
                        break;
                    }
                    default: {
                        throw xae;
                    }
                }
            }
        }

        void rollback(Xid xid) throws XAException {
            switch (this.state) {
                case 3: 
                case 4: {
                    return;
                }
            }
            try {
                this.resource.rollback(xid);
                this.state = 4;
            }
            catch (XAException xae) {
                switch (xae.errorCode) {
                    case 6: {
                        this.state = 4;
                        break;
                    }
                    case 5: 
                    case 7: 
                    case 8: {
                        this.state = 4;
                        throw xae;
                    }
                    case -7: 
                    case -6: 
                    case -5: 
                    case -3: {
                        throw xae;
                    }
                    case -4: {
                        this.state = 4;
                        break;
                    }
                    default: {
                        throw xae;
                    }
                }
            }
        }

        public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
            this.branchXid = new BranchXidImpl();
            this.branchXid.readExternal(in);
            this.resource = (WSATXAResource)in.readObject();
        }

        public void writeExternal(ObjectOutput out) throws IOException {
            this.resource.setXid(new XidImpl(this.resource.getXid()));
            new BranchXidImpl(this.resource.getXid()).writeExternal(out);
            try {
                out.writeObject(this.resource);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }
}

