﻿using AutoMapper;
using CommonSchemas = HIPS.CommonSchemas.Cda;
using ServiceSchemas = HIPS.ServiceContracts.Common.DTO;
using HIPS.AppServer.ServiceHost.Utility;

namespace HIPS.AppServer.ServiceHost.Mapping.Profiles
{
    /// <summary>
    /// AutoMapper mapping profile for the CdaDocument entity.
    /// </summary>
    internal class CdaDocumentProfile : Profile
    {
        #region Methods

        /// <summary>
        /// Configures the maps available as part of this mapping profile.
        /// </summary>
        protected override void Configure()
        {
            // Common --> DTO:
            this.CreateMap<CommonSchemas.Cda.CdaDocument, ServiceSchemas.CdaDocument>();

            this.CreateMap<PcehrSchemas.Attachment, ServiceSchemas.CdaAttachment>()
                .ForMember(dest => dest.Content, opt => opt.MapFrom(src => src.Contents));

            this.CreateMap<CommonSchemas.Cda.CdaDocumentContent, ServiceSchemas.CdaDocumentContent>();

            this.CreateMap<CommonSchemas.Cda.CdaCode, ServiceSchemas.CdaCode>();

            this.CreateMap<CommonSchemas.Cda.ParticipatingIndividual.ParticipatingConsumer, ServiceSchemas.ParticipatingIndividual.ParticipatingConsumer>()
                .ForMember(d => d.Sex, o => o.MapFrom(s => s.Sex.ToService()));

            this.CreateMap<CommonSchemas.Cda.ParticipatingIndividual.ParticipatingProvider, ServiceSchemas.ParticipatingIndividual.ParticipatingProvider>();

            // DTO --> Common:
            this.CreateMap<ServiceSchemas.CdaDocument, CommonSchemas.Cda.CdaDocument>();

            this.CreateMap<ServiceSchemas.CdaAttachment, PcehrSchemas.Attachment>()
                .ForMember(dest => dest.Contents, opt => opt.MapFrom(src => src.Content));

            this.CreateMap<ServiceContracts.Cda.Message.PackageCdaRequest, CommonSchemas.Cda.CdaMetadata>()
                .ForMember(dest => dest.Format, opt => opt.MapFrom(src => src.Format.ToCommonModel()));

            this.CreateMap<ServiceSchemas.MessageAddressee, CommonSchemas.Cda.MessageAddressee>();

            this.CreateMap<ServiceSchemas.ProviderIndividualIdentity, CommonSchemas.Cda.ProviderIndividualIdentity>();

            this.CreateMap<ServiceSchemas.ProviderOrganisationIdentity, CommonSchemas.Cda.ProviderOrganisationIdentity>();

            this.CreateMap<ServiceSchemas.IndividualName, CommonSchemas.Cda.IndividualName>();

            this.CreateMap<ServiceSchemas.ProviderIdentifier, CommonSchemas.Cda.ProviderIdentifier>();

            this.CreateMap<ServiceSchemas.ProviderIdentifierType, CommonSchemas.Cda.ProviderIdentifierType>();

            this.CreateMap<ServiceSchemas.ParticipatingIndividual.ParticipatingConsumer, CommonSchemas.Cda.ParticipatingIndividual.ParticipatingConsumer>()
                .ForMember(d => d.Sex, opt => opt.MapFrom(src => src.Sex.ToSexEnumerator()));
        }

        #endregion Methods
    }
}