﻿using AutoMapper;
using ServiceSchemas = HIPS.ServiceContracts.Common.DTO;

namespace HIPS.AppServer.ServiceHost.Mapping.Profiles
{
    /// <summary>
    /// AutoMapper mapping profile for the User entity.
    /// </summary>
    internal class UserProfile : Profile
    {
        #region Methods

        /// <summary>
        /// Configures the maps available as part of this mapping profile.
        /// </summary>
        protected override void Configure()
        {
            // DTO --> Common:
            this.CreateMap<ServiceSchemas.UserIdentity.LocalUser, CommonSchemas.UserDetails>()
                .ForMember(dest => dest.Role, opt => opt.UseValue(CommonSchemas.UserRole.InteractiveUser))
                .ForMember(dest => dest.Name, opt => opt.MapFrom(src => string.Format("{0} {1}", src.GivenNames, src.FamilyName)));

            this.CreateMap<ServiceSchemas.UserIdentity.ProviderUser, CommonSchemas.UserDetails>()
                .ForMember(dest => dest.Role, opt => opt.UseValue(CommonSchemas.UserRole.ProviderIndividual))
                .ForMember(dest => dest.Name, opt => opt.MapFrom(src => string.Format("{0} {1}", src.GivenNames, src.FamilyName)));

            this.CreateMap<ServiceSchemas.UserIdentity.ResponsibleUser, CommonSchemas.UserDetails>()
                .ForMember(dest => dest.Role, opt => opt.UseValue(CommonSchemas.UserRole.AuthorisedEmployee));
        }

        #endregion Methods
    }
}