﻿using System.ServiceModel;
using HIPS.CommonBusinessLogic.Pcehr;
using HIPS.PcehrSchemas;
using HIPS.ServiceContracts.ServiceInterfaces;
using HIPS.CommonBusinessLogic.Cda;

namespace HIPS.AppServer.ServiceHost
{
    [ServiceBehavior(InstanceContextMode = InstanceContextMode.Single,
                     ConcurrencyMode = ConcurrencyMode.Multiple,
                     ReleaseServiceInstanceOnTransactionComplete = false,
                     TransactionAutoCompleteOnSessionClose = false)]
    public class PcehrQueue : BaseService, IPcehrQueueInterface
    {
        [OperationBehavior(TransactionScopeRequired = true, TransactionAutoComplete = true)]
        public void SendRemoveRequest(QueuedRemoveOperation message)
        {
            DocumentRemoval dr = new DocumentRemoval(message);
            dr.Remove();
        }

        [OperationBehavior(TransactionScopeRequired = true, TransactionAutoComplete = true)]
        public void SendUploadRequest(QueuedUploadOperation message)
        {
            DocumentUpload du = new DocumentUpload(message);
            du.PerformUpload();
        }
        
        [OperationBehavior(TransactionScopeRequired = true, TransactionAutoComplete = true)]
        public void SendPathologyRequest(QueuedHL7ReportOperation message)
        {
            HL7ReportUpload hl7ReportUpload = new HL7ReportUpload(message);
            hl7ReportUpload.UploadPathology();
        }

        [OperationBehavior(TransactionScopeRequired = true, TransactionAutoComplete = true)]
        public void SendImagingRequest(QueuedHL7ReportOperation message)
        {
            HL7ReportUpload hl7ReportUpload = new HL7ReportUpload(message);
            hl7ReportUpload.UploadImaging();
        }
    } 
}