﻿using System;
using System.Runtime.Serialization;

namespace HIPS.Base.Schemas
{
    /// <summary>
    /// Base schema for reference data entities containing a Description attribute.
    /// </summary>
    [KnownType(typeof(BaseListSchema))]
    [Serializable]
    [DataContract]
    public class BaseListSchema : BaseSchema
    {
        #region Private Members

        private string description;

        #endregion Private Members

        #region Properties

        /// <summary>
        /// Gets or sets the description.
        /// </summary>
        /// <value>
        /// The description.
        /// </value>
        [DataBaseInfoAttributes(Enumerators.DatabaseColumnType.Data)]
        [DataMember]
        public string Description
        {
            get
            {
                return description;
            }
            set
            {
                description = value;
#if PUMA_CLIENT
                RaisePropertyChanged(() => Description);
#endif
            }
        }

        #endregion Properties

        #region Overrides

        /// <summary>
        /// Generates a string representation of the entity for logging or debugging purposes.
        /// </summary>
        /// <returns>A string representation of the entity.</returns>
        public override string ToString()
        {
            return Description;
        }

        #endregion Overrides
    }
}