﻿using System.ServiceModel;

using HIPS.ServiceContracts.AckQueue;
using HIPS.ServiceContracts.AckQueue.Message;
using System.Threading.Tasks;

namespace HIPS.Client.Proxy
{
    public class AckServiceProxy : ClientBase<IAckService>, IAckService
    {
        /// <summary>
        /// Initialises a new instance of the <see cref="AckServiceProxy" /> class.
        /// </summary>
        /// <param name="endpointName">The endpoint name in the config file, such as AckServiceEndPoint.</param>
        public AckServiceProxy(string endpointName)
            : base(endpointName)
        {
        }

        /// <summary>
        /// Invokes the SendAck operation of the configured AckService endpoint to deliver the acknowledgement.
        /// </summary>
        /// <param name="request">SendAck Request</param>
        public SendAckResponse SendAck(SendAckRequest request)
        {
            return Channel.SendAck(request);
        }
    }
}
