﻿using System.ServiceModel;
using HIPS.ServiceContracts.Hpii;
using HIPS.ServiceContracts.Hpii.Message;

namespace HIPS.Client.Proxy
{
    /// <summary>
    /// Client proxy for the HPI-I Service V2.
    /// </summary>
    public class HpiiServiceV2Proxy : ClientBase<IHpiiServiceV2>, IHpiiServiceV2
    {
        /// <summary>
        /// Initialises a new instance of the <see cref="HpiiServiceV2Proxy"/> class.
        /// </summary>
        /// <param name="endpointName">The endpoint configuration name</param>
        public HpiiServiceV2Proxy(string endpointName)
            : base(endpointName)
        {
        }

        /// <summary>
        /// This operation retrieves the results of a batch of HPI-I searches from the HI Service.
        /// </summary>
        /// <param name="request">HpiiBatchRetrieveRequest request parameters.</param>
        /// <returns>Response including the results of the batch.</returns>
        public HpiiBatchRetrieveResponse HpiiBatchRetrieve(HpiiBatchRetrieveRequest request)
        {
            return Channel.HpiiBatchRetrieve(request);
        }

        /// <summary>
        /// This operation submits a batch of HPI-I searches to the HI Service.
        /// </summary>
        /// <param name="request">HpiiBatchSubmitRequest request parameters.</param>
        /// <returns>Response including the batch identifier.</returns>
        public HpiiBatchSubmitResponse HpiiBatchSubmit(HpiiBatchSubmitRequest request)
        {
            return Channel.HpiiBatchSubmit(request);
        }

        /// <summary>
        /// This operation submits an HPI-I demographic search to the HI Service.
        /// </summary>
        /// <param name="request">HpiiDemographicSearchRequest request parameters.</param>
        /// <returns>Response including the search results.</returns>
        public HpiiDemographicSearchResponse HpiiDemographicSearch(HpiiDemographicSearchRequest request)
        {
            return Channel.HpiiDemographicSearch(request);
        }

        /// <summary>
        /// This operation submits an HPI-I identifier search to the HI Service.
        /// </summary>
        /// <param name="request">HpiiIdentifierSearchRequest request parameters.</param>
        /// <returns>Response including the search results.</returns>
        public HpiiIdentifierSearchResponse HpiiIdentifierSearch(HpiiIdentifierSearchRequest request)
        {
            return Channel.HpiiIdentifierSearch(request);
        }

        /// <summary>
        /// List all of the current local providers for the specified facility.
        /// </summary>
        /// <param name="request">List Local Provider request parameters.</param>
        /// <returns>List Local Provider response.</returns>
        public ListLocalProviderResponse ListLocalProviders(ListLocalProviderRequest request)
        {
            return Channel.ListLocalProviders(request);
        }

        /// <summary>
        /// Add or Edit a Local Provider.
        /// </summary>
        /// <param name="request">Add or Edit Local Provider request.</param>
        /// <returns>Add or Edit Local Provider response.</returns>
        public AddEditLocalProviderResponse AddEditLocalProvider(AddEditLocalProviderRequest request)
        {
            return Channel.AddEditLocalProvider(request);
        }

        /// <summary>
        /// Add or Replace a Local Provider Identifier.
        /// </summary>
        /// <param name="request">Add or Replace Local Provider Identifier request.</param>
        /// <returns>Add or Replace Local Provider Identifier response.</returns>
        public AddReplaceLocalProviderIdentifierResponse AddReplaceLocalProviderIdentifier(AddReplaceLocalProviderIdentifierRequest request)
        {
            return Channel.AddReplaceLocalProviderIdentifier(request);
        }

        /// <summary>
        /// Deactivates or removes deactivation a local provider.
        /// </summary>
        /// <param name="request">Deactivate Local Provider request parameters.</param>
        /// <returns>Deactivate Local Provider response.</returns>
        public DeactivateLocalProviderResponse DeactivateLocalProvider(DeactivateLocalProviderRequest request)
        {
            return Channel.DeactivateLocalProvider(request);
        }
    }
}