﻿#region Using Directives

using System.ServiceModel;
using HIPS.CommonSchemas;
using HIPS.IhiSchemas.Schemas;
using HIPS.ServiceContracts.ServiceInterfaces;

#endregion Using Directives

namespace HIPS.Client.Proxy
{
    /// <summary>
    /// Client proxy for the PUMA Interface service.
    /// </summary>
    public class PumaInterfaceProxy : ClientBase<IPumaInterfaceService>, IPumaInterfaceService
    {
        /// <summary>
        /// Default constructor
        /// </summary>
        /// <param name="endpointName">The configured endpoint name</param>
        public PumaInterfaceProxy(string endpointName)
            : base(endpointName)
        {
        }

        /// <summary>
        /// Search for an IHI by number, but do not check to see if the PCEHR exists.
        /// </summary>
        /// <param name="hospitalId">The hospital ID.</param>
        /// <param name="searchDetails">The search details.</param>
        /// <param name="user">Information to identify the person responsible for this action.</param>
        /// <returns>HIPS IHI Response.</returns>
        public HipsIhiResponse IHISearchByNumber(int hospitalId, IhiSearchCriteria searchDetails, UserDetails user)
        {
            return Channel.IHISearchByNumber(hospitalId, searchDetails, user);
        }

        /// <summary>
        /// Search for an IHI by number, and check to see if the PCEHR exists.
        /// </summary>
        /// <param name="hospitalId">The hospital ID.</param>
        /// <param name="searchDetails">The search details.</param>
        /// <param name="user">Information to identify the person responsible for this action.</param>
        /// <returns>HIPS IHI Response.</returns>
        public HipsIhiResponse IHISearchByNumberAndPCEHRCheck(int hospitalId, IhiSearchCriteria searchDetails, UserDetails user)
        {
            return Channel.IHISearchByNumberAndPCEHRCheck(hospitalId, searchDetails, user);
        }
    }
}