﻿using System.Data.SqlClient;
using HIPS.Base.Schemas;
using HIPS.Common.PcehrDataStore.DataAccess;
using HIPS.CommonSchemas;

namespace HIPS.PcehrDataStore.DataAccess
{
    /// <summary>
    /// This class provides access  to the error message table
    /// </summary>
    public class SystemErrorLogDl : BaseDl
    {
        #region Constructors

        public SystemErrorLogDl(UserDetails user)
            : base(user)
        {
        }

        #endregion Constructors

        #region Methods

        /// <summary>
        /// Inserts the specified item.
        /// </summary>
        /// <param name="item">The item.</param>
        /// <returns></returns>
        public bool Insert(SystemErrorLog item)
        {
            using (SqlCommand command = GetSqlCommand("hips.SystemErrorLogInsert"))
            {
                command.Connection.Close();
                return base.Insert<SystemErrorLog>(item, command);
            }
        }

        #endregion Methods
    }
}