﻿using System;

using HIPS.CommonSchemas;

namespace HIPS.CommonBusinessLogic.Service
{
    /// <summary>
    /// Abstract base class for business classes.
    /// </summary>
    public abstract class BusinessServiceBase
    {
        #region Constructors

        /// <summary>
        /// Initialises a new instance of the <see cref="BusinessServiceBase" /> class.
        /// </summary>
        /// <param name="userContext">End-user context within which the class is being accessed.</param>
        protected BusinessServiceBase(UserDetails userContext)
        {
            if (userContext == null)
            {
                throw new ArgumentNullException("userContext");
            }
            this.UserContext = userContext;
        }

        #endregion Constructors

        #region Properties

        /// <summary>
        /// Gets the end-user context within which the class is being accessed.
        /// </summary>
        protected UserDetails UserContext { get; private set; }

        #endregion Properties
    }
}