﻿namespace HIPS.CommonSchemas.Cda
{
    /// <summary>
    /// Represents the content of a CDA document.
    /// </summary>
    public class CdaDocumentContent
    {
        #region Properties

        /// <summary>
        /// Gets or sets the author of the CDA document.
        /// </summary>
        public ParticipatingIndividual.ParticipatingProvider Author { get; set; }

        /// <summary>
        /// Gets or sets the document type of the CDA document.
        /// </summary>
        public CdaCode DocumentType { get; set; }

        /// <summary>
        /// Gets or sets the patient within the CDA document.
        /// </summary>
        public ParticipatingIndividual.ParticipatingConsumer Patient { get; set; }

        #endregion
    }
}
