﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Threading.Tasks;

namespace HIPS.CommonSchemas.Cda
{
    /// <summary>
    /// Store all of the Pathology and Diagnostic Imaging related data required for the CDA® Document creation.
    /// </summary>
    public class CdaPathDIDocumentDetails
    {
        /// <summary>
        /// The above CdaDocumentDetails object.
        /// </summary>
        public CdaDocumentDetails CdaDocumentDetails { get; set; }
        
        /// <summary>
        /// A list of Pathology Test Result objects.
        /// </summary>
        public List<PathologyTestResult> PathologyTestResult { get; set; }
        
        /// <summary>
        /// A list of Imaging Exam Result objects.
        /// </summary>
        public List<ImagingExamResult> ImagingExamResult { get; set; }
        
        /// <summary>
        /// The associated Order Details object.
        /// </summary>
        public OrderDetails OrderDetails { get; set; }
        
        /// <summary>
        /// The associated Related Document Details required for the PDF Report Body.
        /// </summary>
        public RelatedDocumentDetails RelatedDocumentDetails { get; set; }
        
        /// <summary>
        /// The MRN the requesting Hospital has supplied for the Patient/Subject Of Care.
        /// </summary>
        public string RequestingHospitalPatientMrn { get; set; }
    }
}
