﻿namespace HIPS.CommonSchemas.Cda
{
    /// <summary>
    /// Represents the purpose of an address. The valid codes are defined in AS 5017-2006
    /// in the table "Health Care Client Identifier Address Purpose", and the mappings to
    /// CDA in NEHTA eDischarge Summary CDA Implementation Guide v3.4.
    /// </summary>
    public enum AddressPurpose
    {
        /// <summary>
        /// No value has been supplied. This represents an invalid invocation of the web service.
        /// If the address purpose has not been stated, service invokers should send "Unknown".
        /// </summary>
        None = 0,

        /// <summary>
        /// Represents a business, workplace or office address. Maps to CDA address use code "WP".
        /// </summary>
        Business = 1,

        /// <summary>
        /// Represents a mailing or postal address, used to send mail. Maps to CDA address use code "PST".
        /// </summary>
        Mailing = 2,

        /// <summary>
        /// Represents a temporary address, which may be good for visit or mailing. Maps to CDA address use code "TMP".
        /// </summary>
        Temporary = 3,

        /// <summary>
        /// Represents a residential or home address. Maps to CDA address use code "H".
        /// </summary>
        Residential = 4,

        /// <summary>
        /// Represents an address whose purpose has not been stated, is unknown or inadequately
        /// described. In this case the CDA document will simply omit the Address Use Code.
        /// </summary>
        Unknown = 9,
    }

    /// <summary>
    /// Represents the file type and semantics of an attachment.
    /// </summary>
    public enum AttachmentType
    {
        /// <summary>
        /// No value has been supplied. This represents an invalid invocation of the web service.
        /// </summary>
        None = 0,

        /// <summary>
        /// Represents an additional JPEG image attached to the document. This image will be shown
        /// in the CDA body under the main document. This file must be a JPEG image.
        /// </summary>
        AttachedImageJpeg = 1,

        /// <summary>
        /// Represents an additional PNG image attached to the document. This image will be shown
        /// in the CDA body under the main document. This file must be a PNG image.
        /// </summary>
        AttachedImagePng = 2,

        /// <summary>
        /// Represents an additional TIFF image attached to the document. This image will be shown
        /// in the CDA body under the main document. This file must be a TIFF image.
        /// </summary>
        AttachedImageTiff = 3,

        /// <summary>
        /// Represents an additional GIF image attached to the document. This image will be shown
        /// in the CDA body under the main document. This file must be a GIF image.
        /// </summary>
        AttachedImageGif = 4,

        /// <summary>
        /// Represents an additional linked document. This will be linked from the body of the
        /// CDA document. This file must be a PDF document.
        /// </summary>
        AttachedDocumentPdf = 5,

        /// <summary>
        /// Represents the organisational logo that will appear in the header of the CDA document.
        /// This file must be a PNG image.
        /// </summary>
        OrganisationalLogoPng = 6,

        /// <summary>
        /// Represents the non-structured body of the clinical document. This will be the first
        /// linked file in the body of the CDA document. This file must be a PDF document.
        /// </summary>
        DocumentBodyPdf = 7,
    }

    /// <summary>
    /// Represents an Australian state or territory. The valid codes are defined in AS 5017-2006
    /// in the table "Australian State/Territory Identifier - Postal", and the mappings to
    /// CDA are defined in NEHTA "eDischarge Summary CDA Implementation Guide v3.4" to use the
    /// same codes.
    /// </summary>
    public enum AustralianState
    {
        /// <summary>
        /// No value has been supplied. This represents a valid invocation of the web service
        /// for an international address. For an Australian address, if the state or territory
        /// is unknown, service invokers should send "U".
        /// </summary>
        None = 0,

        /// <summary>
        /// Represents New South Wales.
        /// </summary>
        NSW = 1,

        /// <summary>
        /// Represents Victoria.
        /// </summary>
        VIC = 2,

        /// <summary>
        /// Represents Queensland.
        /// </summary>
        QLD = 3,

        /// <summary>
        /// Represents South Australia.
        /// </summary>
        SA = 4,

        /// <summary>
        /// Represents Western Australia.
        /// </summary>
        WA = 5,

        /// <summary>
        /// Represents Tasmania.
        /// </summary>
        TAS = 6,

        /// <summary>
        /// Represents Northern Territory.
        /// </summary>
        NT = 7,

        /// <summary>
        /// Represents Australian Capital Territory.
        /// </summary>
        ACT = 8,

        /// <summary>
        /// Represents an Australian address whose state or territory is unknown.
        /// </summary>
        U = 9,
    }

    /// <summary>
    /// Represents the medium of an electronic communication detail. The valid
    /// codes are defined in AS 5017-2006 in the table "Health Care Client
    /// Electronic Communication Medium", and the mappings to HL7v3 (CDA) URL
    /// schemes in NEHTA "eDischarge Summary CDA Implementation Guide v3.4".
    /// </summary>
    public enum ElectronicCommunicationMedium
    {
        /// <summary>
        /// No value has been supplied. This represents an invalid invocation of the web service.
        /// </summary>
        None = 0,

        /// <summary>
        /// Represents a fixed telephone. Maps to URL scheme "tel".
        /// </summary>
        FixedTelephone = 1,

        /// <summary>
        /// Represents a mobile telephone. Maps to URL scheme "tel" with use code "MC".
        /// </summary>
        Mobile = 2,

        /// <summary>
        /// Represents a facsimile machine. Maps to URL scheme "fax".
        /// </summary>
        Fax = 3,

        /// <summary>
        /// Represents a pager. Maps to URL scheme "tel" with use code "PG".
        /// </summary>
        Pager = 4,

        /// <summary>
        /// Represents email. Maps to URL scheme "mailto".
        /// </summary>
        Email = 5,

        /// <summary>
        /// Represents a URL. The URL scheme of the URL in the Detail element is used without mapping.
        /// </summary>
        URL = 6,
    }

    /// <summary>
    /// Represents the usage of an electronic communication detail. The valid
    /// codes are defined in AS 5017-2006 in the table "Health Care Client
    /// Electronic Communication Usage Code", and the mappings to HL7v3 (CDA)
    /// Telecommunication Address Use (TAU) codes in NEHTA "eDischarge Summary
    /// CDA Implementation Guide v3.4".
    /// </summary>
    public enum ElectronicCommunicationUsage
    {
        /// <summary>
        /// No value has been supplied. This represents a valid invocation of the web service because the usage code is optional.
        /// </summary>
        None = 0,

        /// <summary>
        /// Represents a communication address for business use. Maps to TAU code "WP".
        /// </summary>
        Business = 1,

        /// <summary>
        /// Represents a communication address for personal use. Maps to TAU code "H".
        /// </summary>
        Personal = 2,

        /// <summary>
        /// Represents a  communication address for both business and personal use. Maps to TAU code "WP H".
        /// </summary>
        Both = 3,
    }

    /// <summary>
    /// Represents the usage for an individual name.
    /// </summary>
    public enum IndividualNameUsage
    {
        /// <summary>
        /// No value has been supplied. This represents an invalid invocation
        /// of the web service.
        /// </summary>
        None = 0,

        /// <summary>
        /// Represents the registered name (legal name). This is the name that
        /// was used in the successful search for the IHI in the HI Service.
        /// </summary>
        RegisteredName = 1,

        /// <summary>
        /// Represents a reporting name. This is the name recorded on a licence
        /// or certificate, if different to the legal name.
        /// </summary>
        ReportingName = 2,

        /// <summary>
        /// Represents a newborn name. This is a temporary name assigned to a
        /// newborn baby.
        /// </summary>
        NewbornName = 3,

        /// <summary>
        /// Represents a professional or business name. This includes a
        /// writer's pseudonym or a stage name.
        /// </summary>
        ProfessionalName = 4,

        /// <summary>
        /// Represents a maiden name. This is the name used prior to marriage.
        /// </summary>
        MaidenName = 5,

        /// <summary>
        /// Represents an other name or alias. This is a self-asserted name
        /// that the person is using or has used.
        /// </summary>
        OtherName = 6,
    }

    /// <summary>
    /// Represents the status of the patient at the time of discharge and the
    /// place to which the person was or will be released. The valid codes
    /// are defined in AIHW 270094 titled "Episode of admitted patient care-
    /// separation mode, code N". Shorter, more user friendly display names
    /// were developed by NEHTA.
    /// </summary>
    public enum ModeOfSeparation
    {
        /// <summary>
        /// No value has been supplied. This represents an invalid invocation of the web service.
        /// </summary>
        None = 0,

        /// <summary>
        /// Represents a discharge or transfer to an acute hospital.
        /// </summary>
        AcuteHospital = 1,

        /// <summary>
        /// Represents a discharge or transfer to a residential aged care service, unless this is the usual place of residence.
        /// </summary>
        AgedCareService = 2,

        /// <summary>
        /// Represents a discharge or transfer to a psychiatric hospital.
        /// </summary>
        PsychiatricCare = 3,

        /// <summary>
        /// Represents a discharge or transfer to other health care accommodation (includes mothercraft hospitals)
        /// </summary>
        OtherHealthService = 4,

        /// <summary>
        /// Represents a statistical discharge - type change.
        /// </summary>
        AdministrativeDischarge = 5,

        /// <summary>
        /// Represents that the patient left against medical advice or was discharged at own risk.
        /// </summary>
        SelfDischarge = 6,

        /// <summary>
        /// Represents a statistical discharge from leave.
        /// </summary>
        AdministrativeFromLeave = 7,

        /// <summary>
        /// Represents that the patient died.
        /// </summary>
        Deceased = 8,

        /// <summary>
        /// Represents that the patient was discharged to his/her usual residence, own accommodation or a welfare institution (includes prisons, hostels and group homes providing primarily welfare services).
        /// </summary>
        Home = 9,
    }

    /// <summary>
    /// Represents the status of this version of the document as communicated
    /// by the source system. The valid codes are defined by NCTIS titled
    /// "Admin Codes - Document Status".
    /// </summary>
    public enum SourceDocumentStatus
    {
        /// <summary>
        /// No value has been supplied. This represents an invalid invocation of the web service.
        /// </summary>
        None = 0,

        /// <summary>
        /// Represents an interim or draft version of the document. Interim versions are not normally
        /// uploaded to the PCEHR system.
        /// </summary>
        Interim = 1,

        /// <summary>
        /// Represents a final version of the document. This may be the first final version or an amendment.
        /// </summary>
        Final = 2,

        /// <summary>
        /// Represents a notification that the document has been withdrawn by the authoring organisation.
        /// Withdrawn versions are intended for delivery to point-to-point (P2P) recipients of the document
        /// and are not normally uploaded to the PCEHR system. Instead the document can be removed from the
        /// PCEHR system with a separate web service invocation.
        /// </summary>
        Withdrawn = 3,
    }
}