﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Threading.Tasks;

using HIPS.CommonSchemas.Cda.ParticipatingIndividual;

namespace HIPS.CommonSchemas.Cda
{
    /// <summary>
    /// Store all of the Order Details that is common across both the Pathology and Diagnostic Imaging. 
    /// </summary>
    public class OrderDetails
    {
        /// <summary>
        /// The participant object of the requesting Provider.
        /// </summary>
        public ParticipatingProvider Requester { get; set; }
        
        /// <summary>
        /// The local identifier assigned to the order by the order requester.
        /// </summary>
        public string OrderIdentifier { get; set; }
        
        /// <summary>
        /// An Accession Number assigned by the order receiver.
        /// </summary>
        public string DiagnosticImagingAccessionNumber { get; set; }
        
        /// <summary>
        /// The name of the Pathology Test the requested has requested.
        /// </summary>
        public string PathologyRequestedTestName { get; set; }
    }
}
