﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Threading.Tasks;

namespace HIPS.CommonSchemas.Cda
{
    /// <summary>
    /// Store all of the Pathology and Diagnostic Imaging related data required for the CDA® Document creation. 
    /// </summary>
    public class RelatedDocumentDetails
    {
        /// <summary>
        /// Report description or title.
        /// </summary>
        public string ReportDescription { get; set; }
        
        /// <summary>
        /// The Health Facilities local identifier.
        /// </summary>
        public string LocalIdentifier { get; set; }
        
        /// <summary>
        /// Date and Time of the Report.
        /// </summary>
        public DateTime ReportDateTime { get; set; }
        
        /// <summary>
        /// The Report Result Status HL7® Table 0123.
        /// </summary>
        public string ResultStatus { get; set; }
    }
}
