﻿namespace HIPS.CommonSchemas
{
    /// <summary>
    /// Common constants.
    /// </summary>
    public class Constants
    {
        /// <summary>
        /// Set of origins.
        /// </summary>
        public class Origin
        {
            /// <summary>
            /// Represents an origin of the HIPS core application server.
            /// </summary>
            public const string HIPS = "nehta.hips";

            /// <summary>
            /// Represents an origin of the HIPS P2P application server.
            /// </summary>
            public const string HIPS_P2P = "nehta.hips.p2p";
        
            /// <summary>
            /// Represents an origin of the Healthcare Identifier (HI) Service.
            /// </summary>
            public const string HI_SERVICE = "au.gov.medicareaustralia.hiservice";

            /// <summary>
            /// Represents an origin of the Personally Controlled Electronic Health Record (PCEHR) System.
            /// </summary>
            public const string PCEHR_SYSTEM = "au.gov.ehealth.pcehr";
        }
    }
}