﻿using System;

namespace HIPS.CommonSchemas.Exceptions
{
    /// <summary>
    /// Exception type that wraps a legacy HipsResponse object.
    /// </summary>
    public class HipsResponseException : Exception
    {
        /// <summary>
        /// Initialises a new instance of the <see cref="HipsResponseException" /> class.
        /// </summary>
        /// <param name="detail">The detailed HIPS response object.</param>
        public HipsResponseException(HipsResponse detail)
            : base(detail.HipsErrorMessage)
        {
            this.Detail = detail;
        }

        /// <summary>
        /// Gets the detailed HIPS response object.
        /// </summary>
        public HipsResponse Detail { get; internal set; }
    }
}