﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Threading.Tasks;

namespace HIPS.CommonSchemas.Exceptions
{
    /// <summary>
    /// This exception is thrown when the Hpii lookup returns eithhr a Retired or Deactivated Hpii status. 
    /// The application support team do not need to see the message, so an "INFO" message is written to the log.
    ///
    /// The HL7 message broker should skip to the next message. Therefore a
    /// successful "AA" HL7 acknowledgement will be returned.
    /// </summary>
    public class HpiiInfoException : Exception
    {
        /// <summary>
        /// Initialises a new instance of the <see cref="HpiiInfoException"/> class.
        /// </summary>
        /// <param name="textMessage">The error message text.</param>
        public HpiiInfoException(string textMessage)
            : base(textMessage)
        {
        }
    }
}
