﻿using System;
using System.Runtime.Serialization;
using HIPS.Base.Schemas;
using HIPS.Base.Schemas.Enumerators;

namespace HIPS.CommonSchemas.Hi
{
    /// <summary>
    /// This class represents a HI State for addressing
    /// </summary>
    [KnownType(typeof(HiState))]
    [Serializable]
    [DataContract]
    public class HiState : BaseExposedCode
    {
        /// <summary>
        /// Initialises a new instance of the <see cref="HiState"/> class.
        /// </summary>
        public HiState()
            : base()
        {
        }

        /// <summary>
        /// Gets or sets the State id.
        /// </summary>
        /// <value>
        /// The State id.
        /// </value>
        [DataMember]
        [DataBaseInfoAttributes(DatabaseColumnType.ApplicationGeneratedKey)]
        public int? StateId
        {
            get
            {
                return base.Id;
            }
            set
            {
                base.Id = value;
            }
        }
    }
}