﻿using System;
using System.Runtime.Serialization;
using HIPS.Base.Schemas;
using HIPS.Base.Schemas.Enumerators;

namespace HIPS.CommonSchemas.Hi
{
    /// <summary>
    /// This class represents a HI StreetSuffixType for addressing
    /// </summary>
    [KnownType(typeof(HiStreetSuffixType))]
    [Serializable]
    [DataContract]
    public class HiStreetSuffixType : BaseExposedCode
    {
        /// <summary>
        /// Initialises a new instance of the <see cref="HiStreetSuffixType"/> class.
        /// </summary>
        public HiStreetSuffixType()
            : base()
        {
        }

        /// <summary>
        /// Gets or sets the StreetSuffixType id.
        /// </summary>
        /// <value>
        /// The StreetSuffixType id.
        /// </value>
        [DataMember]
        [DataBaseInfoAttributes(DatabaseColumnType.ReadOnlyData)]
        public int? StreetSuffixTypeId
        {
            get
            {
                return base.Id;
            }
            set
            {
                base.Id = value;
            }
        }
    }
}