﻿using System;
using System.Runtime.Serialization;
using HIPS.Base.Schemas;
using HIPS.Base.Schemas.Enumerators;

namespace HIPS.CommonSchemas.Hi
{
    /// <summary>
    /// This class represents a HI StreetType for addressing
    /// </summary>
    [KnownType(typeof(HiStreetType))]
    [Serializable]
    [DataContract]
    public class HiStreetType : BaseExposedCode
    {
        /// <summary>
        /// Initialises a new instance of the <see cref="HiStreetType"/> class.
        /// </summary>
        public HiStreetType()
            : base()
        {
        }

        /// <summary>
        /// Gets or sets the StreetType id.
        /// </summary>
        /// <value>
        /// The StreetType id.
        /// </value>
        [DataMember]
        [DataBaseInfoAttributes(DatabaseColumnType.ApplicationGeneratedKey)]
        public int? StreetTypeId
        {
            get
            {
                return base.Id;
            }
            set
            {
                base.Id = value;
            }
        }
    }
}