﻿using System.Runtime.Serialization;

namespace HIPS.CommonSchemas
{
    /// <summary>
    /// This schema is used to identify a hospital / facility.
    /// </summary>
    [DataContract]
    public class HospitalIdentifier
    {
        #region Private Members

        private string hospitalCode;
        private string hospitalCodeSystem;

        #endregion Private Members

        #region Properties

        /// <summary>
        /// A code identifying the hospital in which this patient received health care.
        /// </summary>
        [DataMember]
        public string HospitalCode
        {
            get { return hospitalCode; }
            set { hospitalCode = value; }
        }

        /// <summary>
        /// A code identifying the system under which the hospital code was allocated.
        /// </summary>
        [DataMember]
        public string HospitalCodeSystem
        {
            get { return hospitalCodeSystem; }
            set { hospitalCodeSystem = value; }
        }

        #endregion Properties

        #region Constructors

        /// <summary>
        /// Specific constructor for the class HospitalIdentifier.
        /// </summary>
        /// <param name="hospitalCode">The hospital code</param>
        /// <param name="hospitalCodeSystem">The hospital code system</param>
        public HospitalIdentifier(string hospitalCode, string hospitalCodeSystem)
        {
            this.hospitalCode = hospitalCode;
            this.hospitalCodeSystem = hospitalCodeSystem;
        }

        #endregion Constructors
    }
}