﻿using System.Runtime.Serialization;

namespace HIPS.CommonSchemas.PatientIdentifier
{
    /// <summary>
    /// This Patient Identifier is used for the Identity Column on the PatientMaster Table
    /// </summary>
    [DataContract]
    public class PatientMasterId : PatientIdentifierBase
    {
        #region Private Members

        private int? hospitalId;
        private int patientMasterId;

        #endregion Private Members

        #region Properties

        /// <summary>
        /// Gets or sets the HospitalId (HIPS database Hospital table primary key). If supplied, overrides the hospital code and code system.
        /// </summary>
        /// <value>
        /// Value
        /// </value>
        [DataMember]
        public int? HospitalId
        {
            get
            {
                return hospitalId;
            }
            set
            {
                hospitalId = value;
            }
        }

        /// <summary>
        /// Gets or sets the PatientMasterId (HIPS database PatientMaster table primary key).
        /// </summary>
        /// <value>
        /// Value
        /// </value>
        [DataMember]
        public int Value
        {
            get
            {
                return patientMasterId;
            }
            set
            {
                patientMasterId = value;
            }
        }

        #endregion Properties

        #region Methods

        /// <summary>
        /// Initialises a new instance of the <see cref="PatientMasterId" /> class. This basic constructor is used by AutoMapper.
        /// </summary>
        public PatientMasterId()
        {
        }

        /// <summary>
        /// Specific constructor for the patient master identifier.
        /// </summary>
        /// <param name="patientMasterId">The patient master identifier (HIPS database PatientMaster table primary key)</param>
        /// <param name="hospitalCode">The hospital code</param>
        /// <param name="hospitalCodeSystem">The hospital code system</param>
        /// <param name="hospitalId">The hospital ID (HIPS database Hospital table primary key). If supplied, overrides the hospital code and code system.</param>
        public PatientMasterId(int patientMasterId, string hospitalCode, string hospitalCodeSystem, int? hospitalId = -1)
            : base(hospitalCode, hospitalCodeSystem)
        {
            this.patientMasterId = patientMasterId;
            this.hospitalId = hospitalId;
        }

        /// <summary>
        /// Represents the PatientMasterId patient identifier as a string for logging and debugging purposes.
        /// </summary>
        /// <returns>A string representation of the object.</returns>
        public override string ToString()
        {
            return string.Format("PatientMasterId: {0}", patientMasterId);
        }

        #endregion Methods
    }
}