﻿namespace HIPS.ConsentSchemas
{
    /// <summary>
    /// This enumeration represents the status of a consent service operation, whether successful or a particular type of error.
    /// </summary>
    public enum ConsentReturnStatus
    {
        /// <summary>
        /// The request executed correctly.
        /// </summary>
        OK = 0,

        /// <summary>
        /// The patient was not found with the specified search data.
        /// </summary>
        InvalidPatient = 1,

        /// <summary>
        /// The hospital was not found with the specified search data.
        /// </summary>
        InvalidHospital = 2,

        /// <summary>
        /// The episode was not found with the specified search data.
        /// </summary>
        InvalidEpisode = 3,

        /// <summary>
        /// The PCEHR service returned an error.
        /// </summary>
        ServiceError = 9,

        /// <summary>
        /// The application failed. Details recorded within the application database.
        /// </summary>
        SystemError = 99
    }

    /// <summary>
    /// This enumeration represents the consent status for uploading documents to the PCEHR relating to
    /// a particular episode of care.
    /// </summary>
    public enum EpisodeConsentStatus
    {
        /// <summary>
        /// The consent status is unknown.
        /// </summary>
        Unknown,

        /// <summary>
        /// Consent information was not recorded for this episode. Consent is granted when the person registers for a PCEHR.
        /// </summary>
        NoConsentRecorded,

        /// <summary>
        /// The patient has withdrawn consent for uploading documents related to this episode.
        /// </summary>
        WithdrewConsent
    }

    /// <summary>
    /// Represents the PCEHR participation status of a patient.
    /// </summary>
    public enum ParticipationStatus
    {
        /// <summary>
        /// HIPS was not able to obtain or validate the IHI for this patient. HIPS will not be able to
        /// upload the discharge summary for this patient until this situation is resolved.
        /// </summary>
        NoValidIhi,

        /// <summary>
        /// This patient may not have registered for PCEHR, or may have chosen to hide the existence of
        /// his/her PCEHR. The clinical system should not send the discharge summary, unless the patient
        /// explicitly requests the provider to do so.
        /// </summary>
        PcehrNotAdvertised,

        /// <summary>
        /// This patient has chosen to advertise the existence of his/her PCEHR, or the health provider
        /// organisation has already gained access to the PCEHR, so the clinical system should send the
        /// discharge summary.
        /// </summary>
        PcehrAdvertised,

        /// <summary>
        /// This patient disclosed the existence of his/her PCEHR to the health provider organisation, and
        /// thereby requested the upload of his/her discharge summary for all hospitals that are part of
        /// this health provider organisation, so the clinical system should send the discharge summary,
        /// regardless of whether the PCEHR is advertised.
        /// </summary>
        RequestedUpload
    }
}