﻿using System;
using System.Collections.Generic;
using System.Runtime.Serialization;
using HIPS.CommonSchemas;
using nehta.mcaR50.ProviderSearchForProviderIndividual;

namespace HIPS.HpiiSchemas
{
    /// <summary>
    /// This class represents the response when retrieving the results of a batch of HPI-I queries.
    /// </summary>
    [KnownType(typeof(HpiiBatchAsyncRetrieveResponse))]
    [Serializable]
    [DataContract]
    public class HpiiBatchAsyncRetrieveResponse
    {
        #region Private Members

        private string batchIdentifier;
        private HipsResponse hipsResponse = new HipsResponse(HipsResponseIndicator.SystemError, null);
        private IList<HpiiBatchQueryResponse> hpiiBatchQueryResponses;
        private ServiceMessagesType serviceMessagesType;

        #endregion Private Members

        #region Properties

        /// <summary>
        /// Gets or sets the batch identifier.
        /// </summary>
        [DataMember]
        public string BatchIdentifier
        {
            get { return batchIdentifier; }
            set { batchIdentifier = value; }
        }

        /// <summary>
        /// Gets or sets the HIPS response.
        /// </summary>
        [DataMember]
        public HipsResponse HipsResponse
        {
            get { return hipsResponse; }
            set { hipsResponse = value; }
        }

        /// <summary>
        /// Gets or sets a list of HPI-I batch query responses.
        /// </summary>
        [DataMember]
        public IList<HpiiBatchQueryResponse> HpiiBatchQueryResponses
        {
            get { return hpiiBatchQueryResponses; }
            set { hpiiBatchQueryResponses = value; }
        }

        /// <summary>
        /// Gets or sets the service messages.
        /// </summary>
        [DataMember]
        public ServiceMessagesType ServiceMessagesType
        {
            get { return serviceMessagesType; }
            set { serviceMessagesType = value; }
        }

        #endregion Properties
    }
}