﻿using System;
using System.Collections.Generic;
using System.Runtime.Serialization;
using HIPS.PcehrDataStore.Schemas.Enumerators;

namespace HIPS.IhiSchemas.Schemas
{
    /// <summary>
    /// This class represents a set of IHI search criteria.
    /// </summary>
    [KnownType(typeof(IhiSearchCriteria))]
    [Serializable]
    [DataContract]
    public class IhiSearchCriteria
    {
        #region Private Fields

        private DateTime? dateOfBirth;
        private string dvaNumber;
        private string ihi;
        private DateTime ihiLastUpdated;
        private bool? isMedicareNumberValid;
        private string medicareIrn;
        private string medicareNumber;
        private List<IhiSearchCriteriaName> names;
        private int patientMasterId;
        private bool? pcehrExists;
        private string response;
        private IhiRecordStatus returnedIhiRecordStatus;
        private IhiStatus returnedIhiStatus;

        #endregion Private Fields

        #region Query Properties

        /// <summary>
        /// Gets or sets the date of birth.
        /// </summary>
        /// <value>
        /// The date of birth.
        /// </value>
        [DataMember]
        public DateTime? DateOfBirth
        {
            get
            {
                return dateOfBirth;
            }
            set
            {
                dateOfBirth = value;
            }
        }

        /// <summary>
        /// Gets or sets the DVA file number - not required if a Medicare number is passed in.
        /// </summary>
        /// <value>
        /// The dva number.
        /// </value>
        [DataMember]
        public string DvaNumber
        {
            get
            {
                return dvaNumber;
            }
            set
            {
                dvaNumber = value;
            }
        }

        /// <summary>
        /// Gets or sets the is medicare number valid indicator.
        /// </summary>
        /// <value>
        /// The is medicare number valid.
        /// </value>
        [DataMember]
        public bool? IsMedicareNumberValid
        {
            get
            {
                return isMedicareNumberValid;
            }
            set
            {
                isMedicareNumberValid = value;
            }
        }

        /// <summary>
        /// Gets or sets the Medicare individual reference number (IRN) - optional.
        /// </summary>
        /// <value>
        /// The medicare sequence number.
        /// </value>
        [DataMember]
        public string MedicareIrn
        {
            get
            {
                return medicareIrn;
            }
            set
            {
                medicareIrn = value;
            }
        }

        /// <summary>
        /// Gets or sets the Medicare card number - Required if no DVA file number is supplied.
        /// </summary>
        /// <value>
        /// The medicare number.
        /// </value>
        [DataMember]
        public string MedicareNumber
        {
            get
            {
                return medicareNumber;
            }
            set
            {
                medicareNumber = value;
            }
        }

        /// <summary>
        /// Gets or sets the names of the patient including their sex.
        /// </summary>
        /// <value>
        /// The names.
        /// </value>
        [DataMember]
        public List<IhiSearchCriteriaName> Names
        {
            get
            {
                return names;
            }
            set
            {
                names = value;
            }
        }

        /// <summary>
        /// Gets or sets the patient master ID.
        /// </summary>
        /// <value>
        /// The patient master ID.
        /// </value>
        [DataMember]
        public int PatientMasterId
        {
            get
            {
                return patientMasterId;
            }
            set
            {
                patientMasterId = value;
            }
        }

        #endregion Query Properties

        #region Result/Return Properties

        /// <summary>
        /// Gets or sets the ihi - Returned from the web service call if valid.
        /// </summary>
        /// <value>
        /// The ihi.
        /// </value>
        [DataMember]
        public string Ihi
        {
            get
            {
                return ihi;
            }
            set
            {
                ihi = value;
            }
        }

        /// <summary>
        /// Gets or sets the ihi last updated.
        /// </summary>
        /// <value>
        /// The ihi last updated.
        /// </value>
        [DataMember]
        public DateTime IhiLastUpdated
        {
            get
            {
                return ihiLastUpdated;
            }
            set
            {
                ihiLastUpdated = value;
            }
        }

        /// <summary>
        /// Gets or sets a value indicating whether [pcehr exists].
        /// </summary>
        /// <value>
        ///   <c>true</c> if [pcehr exists]; otherwise, <c>false</c>.
        /// </value>
        [DataMember]
        public bool? PcehrExists
        {
            get
            {
                return pcehrExists;
            }
            set
            {
                pcehrExists = value;
            }
        }

        /// <summary>
        /// Gets or sets the response message from the HI Service.
        /// </summary>
        /// <value>
        /// The response.
        /// </value>
        [DataMember]
        public string Response
        {
            get
            {
                return response;
            }
            set
            {
                response = value;
            }
        }

        /// <summary>
        /// Gets or sets the returned ihi record status.
        /// </summary>
        /// <value>
        /// The returned ihi record status.
        /// </value>
        [DataMember]
        public IhiRecordStatus ReturnedIhiRecordStatus
        {
            get
            {
                return returnedIhiRecordStatus;
            }
            set
            {
                returnedIhiRecordStatus = value;
            }
        }

        /// <summary>
        /// Gets or sets the returned ihi status.
        /// </summary>
        /// <value>
        /// The returned ihi status.
        /// </value>
        [DataMember]
        public IhiStatus ReturnedIhiStatus
        {
            get
            {
                return returnedIhiStatus;
            }
            set
            {
                returnedIhiStatus = value;
            }
        }

        #endregion Result/Return Properties

        #region Constructors

        /// <summary>
        /// Creates an IhiSearchCriteria object with the returned IHI status
        /// and record status set to Unknown to ensure that the object can
        /// be serialised for transmission into HIPS.
        /// </summary>
        public IhiSearchCriteria()
        {
            ReturnedIhiRecordStatus = IhiRecordStatus.Unknown;
            ReturnedIhiStatus = IhiStatus.Unknown;
        }

        #endregion Constructors
    }
}