﻿using System;
using System.Collections.Generic;
using System.Runtime.Serialization;
using HIPS.CommonSchemas;

namespace HIPS.PatientSchemas
{
    /// <summary>
    /// This object is used for the packaged response from the Episode List web service interface.
    /// </summary>
    [KnownType(typeof(PatientEpisodeListResponse))]
    [Serializable]
    [DataContract(Name = "PatientEpisodeListResponse")]
    public class PatientEpisodeListResponse
    {
        #region Private Members

        private IList<PatientEpisode> episodeList = new List<PatientEpisode>();
        private HipsResponse hipsResponse = new HipsResponse(HipsResponseIndicator.SystemError, null);

        #endregion Private Members

        #region Properties

        /// <summary>
        /// Gets or sets the HipsResponse.
        /// Common Response Object.
        /// </summary>
        /// <value>
        /// The hipsResponse
        /// </value>
        [DataMember]
        public HipsResponse HipsResponse
        {
            get { return hipsResponse; }
            set { hipsResponse = value; }
        }

        /// <summary>
        /// Gets or sets the PatientEpisode IList.
        /// List of the PatientEpisode Items.
        /// </summary>
        /// <value>
        /// The PatientEpisodeList
        /// </value>
        [DataMember]
        public IList<PatientEpisode> PatientEpisodes
        {
            get { return episodeList; }
            set { episodeList = value; }
        }

        #endregion Properties
    }
}