﻿using System;
using System.Collections.Generic;
using System.Data.SqlClient;
using HIPS.Common.DataStore.DataAccess;
using HIPS.Common.PcehrDataStore.DataAccess;
using HIPS.PcehrDataStore.Schemas;
using Enums = HIPS.PcehrDataStore.Schemas.Enumerators;

namespace HIPS.PcehrDataStore.DataAccess
{
    /// <summary>
    /// This class allows access to the EpisodeLifecycle table
    /// </summary>
    public class EpisodeLifecycleDl : BaseDl
    {
        #region Methods

        /// <summary>
        /// Gets the specified EpisodeLifecycle id.
        /// </summary>
        /// <param name="EpisodeLifecycleId">The EpisodeLifecycle id.</param>
        /// <returns></returns>
        public EpisodeLifecycle Get(int EpisodeLifecycleId)
        {
            EpisodeLifecycle result = new EpisodeLifecycle();
            try
            {
                using (SqlCommand command = GetSqlCommand("hips.EpisodeLifecycleGet"))
                {
                    command.Parameters.Add(new SqlParameter("@EpisodeLifecycleId", EpisodeLifecycleId));
                    PopulateBusinessObject<EpisodeLifecycle>(command.ExecuteReader(), result);
                    command.Connection.Close();
                }
            }
            catch (Exception ex)
            {
                EventLogger.WriteLog(ConstantsResource.ErrorMessageEpisodeLifecycleGet, ex, User, Enums.LogMessage.HIPS_MESSAGE_014);
            }
            return result;
        }

        /// <summary>
        /// Gets all.
        /// </summary>
        /// <returns></returns>
        public List<EpisodeLifecycle> GetAll()
        {
            return GetAll(null);
        }

        /// <summary>
        /// Gets all.
        /// </summary>
        /// <returns></returns>
        public List<EpisodeLifecycle> GetAll(DateTime? lastUpdated)
        {
            List<EpisodeLifecycle> results = new List<EpisodeLifecycle>();
            try
            {
                using (SqlCommand command = GetSqlCommand("hips.EpisodeLifecycleGet"))
                {
                    if (lastUpdated.HasValue)
                    {
                        command.Parameters.Add(new SqlParameter("@DateModified", lastUpdated.Value));
                    }
                    results = GetPopulatedBusinessList<EpisodeLifecycle>(command.ExecuteReader());
                    command.Connection.Close();
                }
            }
            catch (Exception ex)
            {
                EventLogger.WriteLog(ConstantsResource.ErrorMessageEpisodeLifecycleGet, ex, User, Enums.LogMessage.HIPS_MESSAGE_013);
            }
            return results;
        }

        #endregion Methods
    }
}