﻿using System;
using System.Collections.Generic;
using System.Data.SqlClient;
using HIPS.Common.DataStore.DataAccess;
using HIPS.Common.PcehrDataStore.DataAccess;
using HIPS.CommonSchemas;
using HIPS.PcehrDataStore.Schemas;
using HIPS.PcehrDataStore.Schemas.Enumerators;

namespace HIPS.PcehrDataStore.DataAccess
{
    /// <summary>
    /// This class retrieves data to show a list of Episodes for a Hospital Patient
    /// </summary>
    public class EpisodeListDl : BaseDl
    {
        #region Constructors

        public EpisodeListDl(UserDetails user)
            : base(user)
        {
        }

        #endregion Constructors

        #region Methods

        /// <summary>
        /// Lists episodes for a patient in hospital
        /// </summary>
        /// <param name="patientId">The patient identifier.</param>
        /// <param name="daysDischarged">In addition to currently admitted
        /// patients, patients who were discharged up to this many days
        /// ago will be included in the list.</param>
        /// <param name="results">The results of a PatientInHospitalEpisode List</param>
        /// <returns>
        /// List of patients in hospital matching the criteria given.
        /// </returns>
        public HipsResponse ListPatientInHospitalEpisodes(int patientId, int daysDischarged, out List<PatientInHospitalEpisode> results)
        {
            HipsResponse response = new HipsResponse(HipsResponseIndicator.OK);
            results = new List<PatientInHospitalEpisode>();
            try
            {
                // Populate the patient list
                using (SqlCommand command = GetSqlCommand("hips.PatientInHospitalEpisodesGet"))
                {
                    AddIntParameter("@PatientId", patientId, command);
                    AddIntParameter("@DaysDischarged", daysDischarged, command);
                    results = GetPopulatedBusinessList<PatientInHospitalEpisode>(command.ExecuteReader());
                    command.Connection.Close();
                }
            }
            catch (Exception ex)
            {
                EventLogger.WriteLog(ConstantsResource.ErrorMessagePatientInHospitalEpisodeList, ex, User, LogMessage.HIPS_MESSAGE_157);
                response.Status = HipsResponseIndicator.DatabaseError;
                response.HipsErrorMessage = ConstantsResource.ErrorMessagePatientInHospitalEpisodeList;
                response.ResponseCode = ex.GetType().Name;
                response.ResponseCodeDescription = ex.Message;
            }
            return response;
        }

        #endregion Methods
    }
}