﻿using System;
using System.Collections.Generic;
using System.Data.SqlClient;
using HIPS.Common.DataStore.DataAccess;
using HIPS.Common.PcehrDataStore.DataAccess;
using HIPS.CommonSchemas;
using HIPS.PcehrDataStore.Schemas;
using HIPS.PcehrDataStore.Schemas.Enumerators;
using HIPS.PcehrDataStore.Schemas.Schemas;

namespace HIPS.PcehrDataStore.DataAccess.DataAccess
{
    /// <summary>
    /// This class allows access to the FillerOrderNumber table
    /// </summary>
    public class FillerOrderNumberDl : BaseDl
    {
         #region Constructors

        /// <summary>
        /// Creates a data access object for the filler order number.
        /// </summary>
        /// <param name="user">The person responsible for the action.</param>
        public FillerOrderNumberDl(UserDetails user)
        {
            this.User = user;
        }

        #endregion Constructors

        #region Methods

        /// <summary>
        /// Gets a SQL command for external transaction handling.
        /// </summary>
        /// <returns>SQL command.</returns>
        public SqlCommand GetCommand()
        {
            return base.Command;
        }

        /// <summary>
        /// Saves the specified FillerOrderNumber.
        /// </summary>
        /// <param name="FillerOrderNumber">The FillerOrderNumber.</param>
        /// <returns>Whether the item was saved.</returns>
        public bool Save(FillerOrderNumber item, SqlTransaction transaction)
        {
            if (item.FillerOrderNumberId.HasValue)
            {
                using (SqlCommand command = GetSqlCommand("hips.FillerOrderNumberUpdate", transaction))
                {
                    return base.Update<FillerOrderNumber>(item, command);
                }
            }
            else
            {
                using (SqlCommand command = GetSqlCommand("hips.FillerOrderNumberInsert", transaction))
                {
                    return base.Insert<FillerOrderNumber>(item, command);
                }
            }
        }


        #endregion
    }
}
