﻿using System;
using System.Collections.Generic;
using System.Data.SqlClient;
using HIPS.Common.DataStore.DataAccess;
using HIPS.Common.PcehrDataStore.DataAccess;
using HIPS.CommonSchemas;
using HIPS.PcehrDataStore.Schemas;
using HIPS.PcehrDataStore.Schemas.Enumerators;

namespace HIPS.PcehrDataStore.DataAccess
{
    /// <summary>
    /// This class allows access to the HealthProviderIndividualHpiiHistory table
    /// </summary>
    public class HealthProviderIndividualHpiiHistoryDl : BaseDl
    {
        #region Constructors

        /// <summary>
        /// Creates a data access object for the health provider individual hpii history.
        /// </summary>
        /// <param name="user">The person responsible for the action.</param>
        public HealthProviderIndividualHpiiHistoryDl(UserDetails user)
        {
            this.User = user;
        }

        #endregion Constructors

        #region Methods

        public bool Insert(HealthProviderIndividualHpiiHistory item, SqlTransaction transaction)
        {
            using (var command = GetSqlCommand("hips.HealthProviderIndividualHpiiHistoryInsert", transaction))
            {
                return base.Insert<HealthProviderIndividualHpiiHistory>(item, command);
            }
        }

        #endregion
    }
}
