﻿using System;
using System.Collections.Generic;
using System.Data.SqlClient;
using HIPS.Common.PcehrDataStore.DataAccess;
using HIPS.CommonSchemas;
using HIPS.PcehrDataStore.Schemas;
using HIPS.Common.DataStore.DataAccess;
using HIPS.PcehrDataStore.Schemas.Enumerators;

namespace HIPS.PcehrDataStore.DataAccess
{
    /// <summary>
    /// This class allows access to the HospitalHealthProviderIndividual table
    /// </summary>
    public class HospitalHealthProviderIndividualDl : BaseDl
    {
        #region Constructors

        /// <summary>
        /// Creates a data access object for the link between a hospital and a health provider individual.
        /// </summary>
        /// <param name="user">The person responsible for the action.</param>
        public HospitalHealthProviderIndividualDl(UserDetails user)
        {
            this.User = user;
        }

        #endregion Constructors

        #region Methods

        public HospitalHealthProviderIndividual Get(int hospitalId, string identifier)
        {
            var result = new HospitalHealthProviderIndividual();
            
            try
            {
                using (SqlCommand command = GetSqlCommand("hips.HospitalHealthProviderIndividualGet"))
                {
                    command.Parameters.Add(new SqlParameter("@HospitalId", hospitalId));
                    command.Parameters.Add(new SqlParameter("@Identifier", identifier));

                    if (!PopulateBusinessObject<HospitalHealthProviderIndividual>(command.ExecuteReader(), result))
                    {
                        result = null;
                    }

                    command.Connection.Close();
                }
            }
            catch (Exception ex)
            {
                string message = string.Format(ConstantsResource.ErrorMessageHospitalHealthProviderIndividualGet, hospitalId, identifier);
                EventLogger.WriteLog(message, ex, User, LogMessage.HIPS_MESSAGE_185);
            }

            return result;
        }

        public HospitalHealthProviderIndividual Get(int hospitalId, int healthProviderIndividualId)
        {
            var result = new HospitalHealthProviderIndividual();

            try
            {
                using (SqlCommand command = GetSqlCommand("hips.HospitalHealthProviderIndividualGet"))
                {
                    command.Parameters.Add(new SqlParameter("@HospitalId", hospitalId));
                    command.Parameters.Add(new SqlParameter("@HealthProviderIndividualId", healthProviderIndividualId));

                    if (!PopulateBusinessObject<HospitalHealthProviderIndividual>(command.ExecuteReader(), result))
                    {
                        result = null;
                    }

                    command.Connection.Close();
                }
            }
            catch (Exception ex)
            {
                string message = string.Format(ConstantsResource.ErrorMessageHospitalHealthProviderIndividualGet, hospitalId, healthProviderIndividualId);
                EventLogger.WriteLog(message, ex, User, LogMessage.HIPS_MESSAGE_185);
            }

            return result;
        }

        /// <summary>
        /// Gets the list of all health provider individual records associated with a particular hospital code system.
        /// </summary>
        /// <returns></returns>
        public List<HospitalHealthProviderIndividual> GetAll(string hospitalCodeSystem)
        {
            List<HospitalHealthProviderIndividual> results = new List<HospitalHealthProviderIndividual>();
            try
            {
                using (SqlCommand command = GetSqlCommand("hips.HospitalHealthProviderIndividualGetAll"))
                {
                    command.Parameters.Add(new SqlParameter("@HospitalCodeSystem", hospitalCodeSystem));

                    results = GetPopulatedBusinessList<HospitalHealthProviderIndividual>(command.ExecuteReader());
                    command.Connection.Close();
                }
            }
            catch (Exception ex)
            {
                EventLogger.WriteLog(ConstantsResource.ErrorMessageHospitalHealthProviderIndividualGetAll, ex, User, LogMessage.HIPS_MESSAGE_185);
            }
            return results;
        }

        /// <summary>
        /// Deletes the specified health care provider.
        /// </summary>
        /// <param name="HealthCareProvider">The health care provider.</param>
        /// <returns></returns>
        // Not implemented yet as it is not required right now.
        public bool Delete(HospitalHealthProviderIndividual hospitalHealthProviderIndividual)
        {
            throw new NotImplementedException("This method has not been implemented");
        }

        /// <summary>
        /// Gets all.
        /// </summary>
        /// <returns></returns>
        // Not implemented yet as it is not required right now.
        public List<HospitalHealthProviderIndividual> GetAll(int healthProviderIndividualId)
        {
            throw new NotImplementedException("This method has not been implemented");
        }

        /// <summary>
        /// Inserts the specified hospital health care provider.
        /// </summary>
        /// <param name="HealthCareProvider">The health care provider.</param>
        /// <returns></returns>
        public bool Insert(HospitalHealthProviderIndividual hospitalHealthProviderIndividual, SqlTransaction transaction = null)
        {
            using (SqlCommand command = GetSqlCommand("hips.HospitalHealthProviderIndividualInsert", transaction))
            {
                return base.Insert<HospitalHealthProviderIndividual>(hospitalHealthProviderIndividual, command);
            }
        }

        /// <summary>
        /// Updates the specified health care provider.
        /// </summary>
        /// <param name="HealthCareProvider">The health care provider.</param>
        /// <returns></returns>
        // Not implemented yet as it is not required right now.
        public bool Update(HospitalHealthProviderIndividual hospitalHealthProviderIndividual)
        {
            using (SqlCommand command = GetSqlCommand("hips.HospitalHealthProviderIndividualUpdate"))
            {
                return base.Insert<HospitalHealthProviderIndividual>(hospitalHealthProviderIndividual, command);
            }
        }

        #endregion Methods       
    }
}