﻿using System.Data.SqlClient;
using HIPS.Common.PcehrDataStore.DataAccess;
using HIPS.CommonSchemas;
using HIPS.PcehrDataStore.Schemas;

namespace HIPS.PcehrDataStore.DataAccess
{
    /// <summary>
    /// This class allows access to the RemoveAudit table.
    /// </summary>
    public class RemoveAuditDl : BaseDl
    {
        #region Constructors

        public RemoveAuditDl(UserDetails user)
            : base(user)
        {
        }

        #endregion Constructors

        #region Methods

        /// <summary>
        /// Inserts the specified remove audit record.
        /// </summary>
        /// <param name="item">The remove audit record.</param>
        /// <returns>Whether the remove audit record was inserted.</returns>
        public bool Insert(RemoveAudit item, SqlTransaction transaction)
        {
            using (SqlCommand command = GetSqlCommand("hips.RemoveAuditInsert", transaction))
            {
                return base.Insert<RemoveAudit>(item, command);
            }
        }

        #endregion Methods
    }
}