﻿using System;
using System.Runtime.Serialization;
using HIPS.Base.Schemas;
using BaseEnumerators = HIPS.Base.Schemas.Enumerators;

namespace HIPS.PcehrDataStore.Schemas
{
    /// <summary>
    /// This class represents an individual versioned Clinical Document
    /// </summary>
    [KnownType(typeof(ClinicalDocumentVersion))]
    [Serializable]
    [DataContract]
    public class ClinicalDocumentVersion : BaseSchema
    {
        #region Private Members

        private int clinicalDocumentId;
        private string sourceSystemDocumentId;
        private DateTime? uploadedDate;
        private DateTime? supersededDate;
        private byte[] package;

        #endregion Private Members

        #region Properties

        /// <summary>
        /// Gets or sets the clinical document version id.
        /// </summary>
        /// <value>
        /// The clinical document version id.
        /// </value>
        [DataMember]
        [DataBaseInfoAttributes(BaseEnumerators.DatabaseColumnType.AutoGeneratedKey)]
        public int? ClinicalDocumentVersionId
        {
            get
            {
                return base.Id;
            }
            set
            {
                base.Id = value;
            }
        }

        /// <summary>
        /// Gets or sets the clinical document id that this version is related to.
        /// </summary>
        /// <value>
        /// The clinical document id.
        /// </value>
        [DataMember]
        [DataBaseInfoAttributes(BaseEnumerators.DatabaseColumnType.Data)]
        public int ClinicalDocumentId
        {
            get
            {
                return clinicalDocumentId;
            }
            set
            {
                clinicalDocumentId = value;
#if PUMA_CLIENT
                RaisePropertyChanged(() => ClinicalDocumentId);
#endif
            }
        }

        /// <summary>
        /// Gets or sets the source system document id.
        /// </summary>
        /// <value>
        /// The source system document id.
        /// </value>
        [DataMember]
        [DataBaseInfoAttributes(BaseEnumerators.DatabaseColumnType.Data)]
        public string SourceSystemDocumentId
        {
            get
            {
                return sourceSystemDocumentId;
            }
            set
            {
                sourceSystemDocumentId = value;
#if PUMA_CLIENT
                RaisePropertyChanged(() => SourceSystemDocumentId);
#endif
            }
        }

        /// <summary>
        /// Gets or sets the date/time the document was uploaded to the PCEHR.
        /// </summary>
        /// <value>
        /// The uploaded date.
        /// </value>
        [DataMember]
        [DataBaseInfoAttributes(BaseEnumerators.DatabaseColumnType.Data)]
        public DateTime? UploadedDate
        {
            get
            {
                return uploadedDate;
            }
            set
            {
                uploadedDate = value;
#if PUMA_CLIENT
                RaisePropertyChanged(() => UploadedDate);
#endif
            }
        }

        /// <summary>
        /// Gets or sets the date that this document was superseded.
        /// </summary>
        /// <value>
        /// The superseded date.
        /// </value>

        [DataMember]
        [DataBaseInfoAttributes(BaseEnumerators.DatabaseColumnType.Data)]
        public DateTime? SupersededDate
        {
            get
            {
                return supersededDate;
            }
            set
            {
                supersededDate = value;

#if PUMA_CLIENT
                RaisePropertyChanged(() => SupersededDate);
#endif
            }
        }

        /// <summary>
        /// Gets or sets the package - This is the zipped clinical document and all it's attachments.
        /// </summary>
        /// <value>
        /// The package.
        /// </value>
        [DataMember]
        [DataBaseInfoAttributes(BaseEnumerators.DatabaseColumnType.Data)]
        public byte[] Package
        {
            get
            {
                return package;
            }
            set
            {
                package = value;
#if PUMA_CLIENT
                RaisePropertyChanged(() => Package);
#endif
            }
        }

        #endregion Properties
    }
}