﻿using System;
using System.Runtime.Serialization;
using HIPS.Base.Schemas;
using BaseEnumerators = HIPS.Base.Schemas.Enumerators;

namespace HIPS.PcehrDataStore.Schemas
{
    /// <summary>
    /// This class represents a PCEHR Upload Consent or withdrawal audit.
    /// </summary>
    [KnownType(typeof(ConsentAudit))]
    [Serializable]
    [DataContract]
    public class ConsentAudit : BaseSchema
    {
        #region Properties

        /// <summary>
        /// Gets or sets the additional audit information, such as a scanned image of the form that the patient signed.
        /// </summary>
        /// <value>
        /// The audit information.
        /// </value>
        [DataMember]
        [DataBaseInfoAttributes(BaseEnumerators.DatabaseColumnType.Data)]
        public byte[] AuditInformation { get; set; }

        /// <summary>
        /// Gets or sets the consent audit ID.
        /// </summary>
        [DataMember]
        [DataBaseInfoAttributes(BaseEnumerators.DatabaseColumnType.AutoGeneratedKey)]
        public int? ConsentAuditId
        {
            get
            {
                return base.Id;
            }
            set
            {
                base.Id = value;
            }
        }

        /// <summary>
        /// Gets or sets the new value for consent withdrawn that the patient has provided.
        /// </summary>
        /// <value>
        /// The new value for consent withdrawn.
        /// </value>
        [DataMember]
        [DataBaseInfoAttributes(BaseEnumerators.DatabaseColumnType.Data)]
        public bool ConsentWithdrawn { get; set; }

        /// <summary>
        /// Gets or sets the episode id.
        /// </summary>
        /// <value>
        /// The episode id.
        /// </value>
        [DataMember]
        [DataBaseInfoAttributes(BaseEnumerators.DatabaseColumnType.Data)]
        public int EpisodeId { get; set; }

        #endregion Properties
    }
}