﻿using System;
using System.Runtime.Serialization;
using HIPS.Base.Schemas;
using BaseEnumerators = HIPS.Base.Schemas.Enumerators;

namespace HIPS.PcehrDataStore.Schemas
{
    /// <summary>
    /// This class represents an episode lifecycle
    /// </summary>
    [KnownType(typeof(EpisodeLifecycle))]
    [Serializable]
    [DataContract]
    public class EpisodeLifecycle : BaseListSchema
    {
        #region Properties

        /// <summary>
        /// Gets or sets the episode lifecycle id.
        /// </summary>
        /// <value>
        /// The episode lifecycle id.
        /// </value>
        [DataMember]
        [DataBaseInfoAttributes(BaseEnumerators.DatabaseColumnType.AutoGeneratedKey)]
        public int? EpisodeLifecycleId
        {
            get
            {
                return base.Id;
            }
            set
            {
                base.Id = value;
            }
        }

        #endregion Properties
    }
}