﻿using System;
using System.Collections.Generic;
using System.Runtime.Serialization;
using HIPS.Base.Schemas;
using HIPS.Base.Schemas.Enumerators;

using BaseEnumerators = HIPS.Base.Schemas.Enumerators;

namespace HIPS.PcehrDataStore.Schemas
{
    /// <summary>
    /// This class represents a health provider individual hpii.
    /// </summary>
    [KnownType(typeof(HealthProviderIndividualHpiiHistory))]
    [Serializable]
    [DataContract]
    public class HealthProviderIndividualHpiiHistory : BaseSchema
    {
        #region Constructors

        /// <summary>
        /// Initialises a new instance of the <see cref="HealthProviderIndividualHpiiHistory" /> class.
        /// </summary>
        public HealthProviderIndividualHpiiHistory()
        {
           
        }

        #endregion Constructors

        #region Properties


        /// <summary>
        /// Gets or sets the HPI-I History id.
        /// </summary>
        /// <value>
        /// The HPI-I History id.
        /// </value>
        [DataMember]
        [DataBaseInfoAttributes(DatabaseColumnType.AutoGeneratedKey)]
        public int? HpiiHistoryId
        {
            get
            {
                return base.Id;
            }
            set
            {
                base.Id = value;
            }
        }

        /// <summary>
        /// Gets or sets the HealthProviderIndividual Id.
        /// </summary>
        /// <value>
        /// The HealthProviderIndividualId.
        /// </value>
        [DataMember]
        [DataBaseInfoAttributes(BaseEnumerators.DatabaseColumnType.Data)]
        public int HealthProviderIndividualId { get; set; }

        /// <summary>
        /// Gets or sets the HealthProviderOrganisationNetwork Id.
        /// </summary>
        /// <value>
        /// The HealthProviderOrganisationNetworkId.
        /// </value>
        [DataMember]
        [DataBaseInfoAttributes(BaseEnumerators.DatabaseColumnType.Data)]
        public int HealthProviderOrganisationNetworkId { get; set; }

        /// <summary>
        /// Gets or sets the hpii.
        /// </summary>
        /// <value>
        /// The hpil.
        /// </value>
        [DataMember]
        [DataBaseInfoAttributes(BaseEnumerators.DatabaseColumnType.Data)]
        public string Hpii { get; set; }

        /// <summary>
        /// Gets or sets the HpiiStatus Id.
        /// </summary>
        /// <value>
        /// The HpiiStatusId.
        /// </value>
        [DataMember]
        [DataBaseInfoAttributes(BaseEnumerators.DatabaseColumnType.Data)]
        public int HpiiStatusId { get; set; }

        #endregion Properties

    }
}
