﻿using System;
using System.Runtime.Serialization;
using HIPS.Base.Schemas;

namespace HIPS.PcehrDataStore.Schemas
{
    /// <summary>
    /// This class represents a type of name
    /// </summary>
    [KnownType(typeof(NameType))]
    [Serializable]
    [DataContract]
    public class NameType : BaseCodeListSchema
    {
        /// <summary>
        /// Gets or sets the name type id.
        /// </summary>
        /// <value>
        /// The name type id.
        /// </value>
        [DataMember]
        [DataBaseInfoAttributes(HIPS.Base.Schemas.Enumerators.DatabaseColumnType.ApplicationGeneratedKey)]
        public int? NameTypeId
        {
            get
            {
                return base.Id;
            }
            set
            {
                base.Id = value;
            }
        }
    }
}