﻿using System;
using System.Runtime.Serialization;
using HIPS.Base.Schemas;
using HIPS.Base.Schemas.Enumerators;

namespace HIPS.PcehrDataStore.Schemas
{
    /// <summary>
    /// This class represents a Patient Master Override Item - Only used for saving
    /// </summary>
    [KnownType(typeof(PatientMasterOverride))]
    [Serializable]
    [DataContract]
    public class PatientMasterOverride : BaseSchema
    {
        /// <summary>
        /// Gets or sets the date of birth.
        /// </summary>
        /// <value>
        /// The date of birth.
        /// </value>
        [DataMember]
        [DataBaseInfoAttributes(DatabaseColumnType.Data)]
        public DateTime? DateOfBirth { get; set; }

        /// <summary>
        /// Gets or sets the dva number.
        /// </summary>
        /// <value>
        /// The dva number.
        /// </value>
        [DataMember]
        [DataBaseInfoAttributes(DatabaseColumnType.Data)]
        public string DvaNumber { get; set; }

        /// <summary>
        /// Gets or sets a value indicating whether this instance is medicare valid.
        /// </summary>
        /// <value>
        /// <c>true</c> if this instance is medicare valid; otherwise, <c>false</c>.
        /// </value>
        [DataMember]
        [DataBaseInfoAttributes(DatabaseColumnType.Data)]
        public bool? IsMedicareNumberValid { get; set; }

        /// <summary>
        /// Gets or sets the medicare irn.
        /// </summary>
        /// <value>
        /// The medicare irn.
        /// </value>
        [DataMember]
        [DataBaseInfoAttributes(DatabaseColumnType.Data)]
        public string MedicareIrn { get; set; }

        /// <summary>
        /// Gets or sets the medicare number.
        /// </summary>
        /// <value>
        /// The medicare number.
        /// </value>
        [DataMember]
        [DataBaseInfoAttributes(DatabaseColumnType.Data)]
        public string MedicareNumber { get; set; }

        /// <summary>
        /// Gets or sets the patient master id.
        /// </summary>
        /// <value>
        /// The patient master id.
        /// </value>
        [DataMember]
        [DataBaseInfoAttributes(DatabaseColumnType.ApplicationGeneratedKey)]
        public int PatientMasterId { get; set; }
    }
}