﻿using System;
using System.Runtime.Serialization;
using HIPS.Base.Schemas;
using HIPS.Base.Schemas.Enumerators;

namespace HIPS.PcehrDataStore.Schemas
{
    /// <summary>
    /// This class represents the title in a name (provider name or patient name)
    /// </summary>
    [KnownType(typeof(Title))]
    [Serializable]
    [DataContract]
    public class Title : BaseCodeListSchema
    {
        /// <summary>
        /// Gets or sets the title id.
        /// </summary>
        /// <value>
        /// The title id.
        /// </value>
        [DataMember]
        [DataBaseInfoAttributes(DatabaseColumnType.AutoGeneratedKey)]
        public int? TitleId
        {
            get
            {
                return base.Id;
            }
            set
            {
                base.Id = value;
            }
        }
    }
}