﻿using System;
using HIPS.Base.Schemas;
using HIPS.Base.Schemas.Enumerators;

namespace HIPS.PcehrDataStore.Schemas
{
    /// <summary>
    /// Represents the data returned from the database for a document uploaded to the PCEHR
    /// </summary>
    public class UploadedClinicalDocument
    {
        /// <summary>
        /// Gets or sets the author person.
        /// </summary>
        /// <value>
        /// The author person.
        /// </value>
        [DataBaseInfoAttributes(DatabaseColumnType.ReadOnlyData)]
        public String authorPerson { get; set; }

        /// <summary>
        /// Gets or sets the name of the author person family.
        /// </summary>
        /// <value>
        /// The name of the author person family.
        /// </value>
        [DataBaseInfoAttributes(DatabaseColumnType.ReadOnlyData)]
        public String authorPersonFamilyName { get; set; }

        /// <summary>
        /// Gets or sets the name of the author person given.
        /// </summary>
        /// <value>
        /// The name of the author person given.
        /// </value>
        [DataBaseInfoAttributes(DatabaseColumnType.ReadOnlyData)]
        public String authorPersonGivenName { get; set; }

        /// <summary>
        /// Gets or sets the author person name prefix.
        /// </summary>
        /// <value>
        /// The author person name prefix.
        /// </value>
        [DataBaseInfoAttributes(DatabaseColumnType.ReadOnlyData)]
        public String authorPersonNamePrefix { get; set; }

        /// <summary>
        /// Gets or sets the clinical document identifier.
        /// </summary>
        /// <value>
        /// The clinical document identifier.
        /// </value>
        [DataBaseInfoAttributes(DatabaseColumnType.ReadOnlyData)]
        public int clinicalDocumentId { get; set; }

        /// <summary>
        /// Gets or sets the clinical document status description.
        /// </summary>
        /// <value>
        /// The clinical document status description.
        /// </value>
        [DataBaseInfoAttributes(DatabaseColumnType.ReadOnlyData)]
        public int clinicalDocumentStatusDescription { get; set; }

        /// <summary>
        /// Gets or sets the clinical document status identifier.
        /// </summary>
        /// <value>
        /// The clinical document status identifier.
        /// </value>
        [DataBaseInfoAttributes(DatabaseColumnType.ReadOnlyData)]
        public int clinicalDocumentStatusId { get; set; }

        /// <summary>
        /// Gets or sets the clinical document version identifier.
        /// </summary>
        /// <value>
        /// The clinical document version identifier.
        /// </value>
        [DataBaseInfoAttributes(DatabaseColumnType.ReadOnlyData)]
        public int clinicalDocumentVersionId { get; set; }

        /// <summary>
        /// Gets or sets the additional audit information for the removal of a document
        /// </summary>
        /// <value>
        /// The audit information.
        /// </value>
        [DataBaseInfoAttributes(DatabaseColumnType.ReadOnlyData)]
        public byte[] DocumentRemovalAuditInformation { get; set; }

        /// <summary>
        /// Gets or sets the document type code.
        /// </summary>
        /// <value>
        /// The document type code.
        /// </value>
        [DataBaseInfoAttributes(DatabaseColumnType.ReadOnlyData)]
        public string documentTypeCode { get; set; }

        /// <summary>
        /// Gets or sets the document type description.
        /// </summary>
        /// <value>
        /// The document type description.
        /// </value>
        [DataBaseInfoAttributes(DatabaseColumnType.ReadOnlyData)]
        public string documentTypeDescription { get; set; }

        /// <summary>
        /// Gets or sets the document type identifier.
        /// </summary>
        /// <value>
        /// The document type identifier.
        /// </value>
        [DataBaseInfoAttributes(DatabaseColumnType.ReadOnlyData)]
        public int documentTypeId { get; set; }

        /// <summary>
        /// Gets or sets the episode identifier.
        /// </summary>
        /// <value>
        /// The episode identifier.
        /// </value>
        [DataBaseInfoAttributes(DatabaseColumnType.ReadOnlyData)]
        public int episodeId { get; set; }

        /// <summary>
        /// Gets or sets the package.
        /// </summary>
        /// <value>
        /// The package.
        /// </value>
        [DataBaseInfoAttributes(DatabaseColumnType.ReadOnlyData)]
        public byte[] package { get; set; }

        /// <summary>
        /// Gets or sets the queue status description.
        /// </summary>
        [DataBaseInfoAttributes(DatabaseColumnType.ReadOnlyData)]
        public string queueStatusDescription { get; set; }

        /// <summary>
        /// Gets or sets the queue status ID.
        /// </summary>
        [DataBaseInfoAttributes(DatabaseColumnType.ReadOnlyData)]
        public int? queueStatusId { get; set; }

        /// <summary>
        /// Gets or sets the removal reason description.
        /// </summary>
        /// <value>
        /// The removal reason description.
        /// </value>
        [DataBaseInfoAttributes(DatabaseColumnType.ReadOnlyData)]
        public string removalReasonDescription { get; set; }

        /// <summary>
        /// Gets or sets the removal reason identifier.
        /// </summary>
        /// <value>
        /// The removal reason identifier.
        /// </value>
        [DataBaseInfoAttributes(DatabaseColumnType.ReadOnlyData)]
        public int removalReasonId { get; set; }

        /// <summary>
        /// Gets or sets the removed date.
        /// </summary>
        /// <value>
        /// The removed date.
        /// </value>
        [DataBaseInfoAttributes(DatabaseColumnType.ReadOnlyData)]
        public DateTime? removedDate { get; set; }

        /// <summary>
        /// Gets or sets the source system document identifier.
        /// </summary>
        /// <value>
        /// The source system document identifier.
        /// </value>
        [DataBaseInfoAttributes(DatabaseColumnType.ReadOnlyData)]
        public string sourceSystemDocumentId { get; set; }

        /// <summary>
        /// Gets or sets the source system set identifier.
        /// </summary>
        /// <value>
        /// The source system set identifier.
        /// </value>
        [DataBaseInfoAttributes(DatabaseColumnType.ReadOnlyData)]
        public string sourceSystemSetId { get; set; }

        /// <summary>
        /// Gets or sets the superseded date.
        /// </summary>
        /// <value>
        /// The superseded date.
        /// </value>
        [DataBaseInfoAttributes(DatabaseColumnType.ReadOnlyData)]
        public DateTime? supersededDate { get; set; }

        /// <summary>
        /// Gets or sets the uploaded date.
        /// </summary>
        /// <value>
        /// The uploaded date.
        /// </value>
        [DataBaseInfoAttributes(DatabaseColumnType.ReadOnlyData)]
        public DateTime? uploadedDate { get; set; }
    }
}