﻿using System;
using System.Configuration;
using HIPS.CommonBusinessLogic;
using HIPS.CommonSchemas;
using HIPS.IhiSchemas.Schemas;
using HIPS.PcehrDataStore.Schemas;
using HIPS.PcehrDataStore.Schemas.Enumerators;
using nehta.mcaR3.ConsumerSearchIHI;

namespace HIPS.PcehrHiBusinessLogic.Ihi
{
    public class PatientRegistration
    {
        #region Methods

        /// <summary>
        /// Performs an IHI search for a newly registered patient.
        /// </summary>
        /// <param name="patientMaster">The patient master</param>
        /// <param name="hospital">The hospital</param>
        /// <param name="user">The health provider individual, interactive user or authorised employee responsible for this action</param>
        /// <returns>The IHI if one was found, otherwise null</returns>
        public string RegisterPatient(PatientMaster patientMaster, Hospital hospital, UserDetails user)
        {
            if (!User.PopulateAndValidateUser(hospital, user))
            {
                throw new Exception(ConstantsResource.InvalidUserDetails);
            }
            IhiSearchCriteria searchDetails = SearchHelper.PopulateSearchDetails(patientMaster);
            string resultMessage;
            searchIHIResponse response;
            bool success = Search.ByNumber(hospital, patientMaster, searchDetails, out resultMessage, out response, user, bool.Parse(ConfigurationManager.AppSettings["CheckDoesPcehrExist"].ToString()));
            if (success)
            {
                patientMaster.Ihi = searchDetails.Ihi;
                patientMaster.IhiStatusId = (int)searchDetails.ReturnedIhiStatus;
                patientMaster.IhiRecordStatusId = (int)searchDetails.ReturnedIhiRecordStatus;
                patientMaster.IhiLastValidated = searchDetails.IhiLastUpdated;

                //patientMaster.PcehrAdvertised = searchDetails.PcehrExists;
            }
            else
            {
                patientMaster.Ihi = null;
                patientMaster.IhiStatusId = (int)IhiStatus.Unknown;
                patientMaster.IhiRecordStatusId = (int)IhiRecordStatus.Unknown;
            }
            return searchDetails.Ihi;
        }

        #endregion Methods
    }
}