﻿using System;
using System.Runtime.Serialization;
using HIPS.CommonSchemas;
using HIPS.PcehrDataStore.Schemas.Enumerators;

namespace HIPS.PcehrSchemas
{
    /// <summary>
    /// This object is used for the package response from the "GainPcehrAccess" methods.
    /// </summary>
    [KnownType(typeof(GainPcehrAccessResponse))]
    [Serializable]
    [DataContract]
    public class GainPcehrAccessResponse
    {
        #region Private Members

        private GainPcehrAccessStatus accessPermission = GainPcehrAccessStatus.Deny;
        private HipsResponse hipsResponse = new HipsResponse(HipsResponseIndicator.SystemError, null);
        private String ihiNumber = null;
        private IhiRecordStatus ihiRecordStatus = IhiRecordStatus.Unknown;
        private IhiStatus ihiStatus = IhiStatus.Unknown;

        #endregion Private Members

        #region Properties

        /// <summary>
        /// Gets or sets the Status of the Access.
        /// </summary>
        [DataMember]
        public GainPcehrAccessStatus AccessPermission
        {
            get { return accessPermission; }
            set { accessPermission = value; }
        }

        /// <summary>
        /// Gets or sets the common response object.
        /// </summary>
        [DataMember]
        public HipsResponse HipsResponse
        {
            get { return hipsResponse; }
            set { hipsResponse = value; }
        }

        /// <summary>
        /// Gets or sets the validated IHI number.
        /// </summary>
        [DataMember]
        public String IHINumber
        {
            get { return ihiNumber; }
            set { ihiNumber = value; }
        }

        /// <summary>
        /// Gets or sets the IHI Record Status - Verified/Unverified.
        /// </summary>
        [DataMember]
        public IhiRecordStatus IhiRecordStatus
        {
            get { return ihiRecordStatus; }
            set { ihiRecordStatus = value; }
        }

        /// <summary>
        /// Gets or sets the IHI Status - Active/Deceased/Retured/Resolved/Expired.
        /// </summary>
        [DataMember]
        public IhiStatus IhiStatus
        {
            get { return ihiStatus; }
            set { ihiStatus = value; }
        }

        #endregion Properties
    }
}